<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections\Modules;

final class CardsSection
{
	public static function render(
		array $options,
		array $modules_cfg,
		array $order,
		array $all_modules,
		array $adaptive_defaults,
		bool $is_pro,
		bool $readonly
	): void {
		echo '<div class="cr-modules-toolbar">';
		echo '<label class="cr-modules-search">';
		echo '<span class="screen-reader-text">搜索模块</span>';
		echo '<input type="search" id="cr-modules-search" placeholder="搜索模块（名称/简介/ID）" />';
		echo '</label>';
		echo '<span id="cr-modules-search-count" class="description"></span>';
		echo '<p id="cr-modules-search-empty" class="description cr-modules-search-empty">未找到匹配的模块。</p>';
		echo '</div>';

		$position_defs = [
			'top' => [
				'title' => '文章页面顶部',
				'desc' => '这些模块会在文章开头渲染（适合概览/要点）。',
			],
			'after' => [
				'title' => '文章中动态插入',
				'desc' => '这些模块会插入正文中（优先贴近最相关小节）。',
			],
			'bottom' => [
				'title' => '文章页面底部',
				'desc' => '这些模块会在文章末尾展示（适合 FAQ/参考资料等）。',
			],
			'code' => [
				'title' => '代码层（不直接展示）',
				'desc' => '不直接渲染在文章中：结构化输出/稳定锚点等。',
			],
		];

		$grouped = [
			'top' => [],
			'after' => [],
			'bottom' => [],
			'code' => [],
		];
		foreach ($order as $mid) {
			$pos = (string)($all_modules[$mid]['position'] ?? 'bottom');
			if (!isset($grouped[$pos])) {
				$pos = 'bottom';
			}
			$grouped[$pos][] = $mid;
		}

		echo '<div id="cr-modules-cards" class="cr-modules-cards">';

		foreach ($position_defs as $pos => $def) {
			$ids = $grouped[$pos] ?? [];
			if ($ids === []) {
				continue;
			}

			echo '<div class="cr-modules-group cr-modules-group--' . esc_attr($pos) . '">';
			echo '<h4 class="cr-modules-group__title">' . esc_html((string)$def['title']) . '</h4>';
			echo '<p class="description cr-modules-group__desc">' . esc_html((string)$def['desc']) . '</p>';
			echo '<div class="cr-modules-group__grid">';

			foreach ($ids as $module_id) {
				$cfg = is_array($modules_cfg[$module_id] ?? null) ? $modules_cfg[$module_id] : [];
				ModuleCard::render($module_id, $cfg, $options, $all_modules, $adaptive_defaults, $is_pro, $readonly);
			}

			echo '</div>'; // grid
			echo '</div>'; // group
		}

		echo '</div>'; // cards
	}
}

