<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSaver;

final class SiteEntrancesTab
{
	public static function apply(array &$options, array $post): void
	{
		if (!is_array($options['site_entrances'] ?? null)) {
			$options['site_entrances'] = [];
		}

		$options['site_entrances']['llms_enabled'] = !empty($post['site_entrances_llms_enabled']);
		$options['site_entrances']['wp_sitemap_control_enabled'] = !empty($post['site_entrances_wp_sitemap_control_enabled']);
		$options['site_entrances']['wp_sitemap_include_posts'] = !empty($post['site_entrances_wp_sitemap_include_posts']);
		$options['site_entrances']['wp_sitemap_include_pages'] = !empty($post['site_entrances_wp_sitemap_include_pages']);
		$options['site_entrances']['wp_sitemap_include_tags'] = !empty($post['site_entrances_wp_sitemap_include_tags']);
		$options['site_entrances']['wp_sitemap_include_users'] = !empty($post['site_entrances_wp_sitemap_include_users']);
		$options['site_entrances']['recommended_urls'] = isset($post['site_entrances_recommended_urls'])
			? sanitize_textarea_field((string)$post['site_entrances_recommended_urls'])
			: '';

		// 清理旧字段（已弃用的自定义 ai-sitemap）。
		unset(
			$options['site_entrances']['ai_sitemap_enabled'],
			$options['site_entrances']['ai_sitemap_include_posts'],
			$options['site_entrances']['ai_sitemap_include_pages'],
			$options['site_entrances']['ai_sitemap_include_tags'],
			$options['site_entrances']['ai_sitemap_include_users']
		);
	}
}

