<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSaver;

use ContentReady\Licensing\Capabilities;
use ContentReady\Modules\Config as ModulesConfig;
use ContentReady\Modules\Registry;
use ContentReady\PageTypes\Config as PageTypesConfig;

final class PageTypesTab
{
	public static function apply(array &$options, array $post): void
	{
		$is_pro = Capabilities::is_pro($options);
		$old_page_types = $options['page_types'] ?? null;
		$options['page_types'] = PageTypesConfig::sanitize_from_post($post, $options);

		// Free 保存时：保留“未展示”的 Pro 模块配置（避免被表单覆盖清空）。
		if (!$is_pro) {
			$existing = PageTypesConfig::normalize_page_types($old_page_types);
			$all_content = array_values(array_filter(ModulesConfig::default_order(), [Registry::class, 'is_content_module']));

			$preserved = [];
			foreach ($existing as $row) {
				if (is_array($row) && isset($row['id'])) {
					$preserved[(string)$row['id']] = [
						'modules' => is_array($row['modules'] ?? null) ? $row['modules'] : [],
						'schema_profile' => PageTypesConfig::normalize_schema_profile((string)($row['schema_profile'] ?? 'article')),
						'schema_mode' => PageTypesConfig::normalize_schema_mode((string)($row['schema_mode'] ?? 'inherit')),
					];
				}
			}

			$out = [];
			foreach ($options['page_types'] as $row) {
				if (!is_array($row)) {
					continue;
				}
				$id = (string)($row['id'] ?? '');
				$mods = is_array($row['modules'] ?? null) ? $row['modules'] : [];
				$old = is_array($preserved[$id] ?? null) ? $preserved[$id] : [];
				$old_modules = is_array($old['modules'] ?? null) ? $old['modules'] : [];
				$keep = [];
				foreach ($old_modules as $mid) {
					$mid = sanitize_key((string)$mid);
					if (Capabilities::module_plan($mid) === Capabilities::PLAN_PRO) {
						$keep[$mid] = true;
					}
				}

				$final = [];
				$want = [];
				foreach ($mods as $mid) {
					$want[sanitize_key((string)$mid)] = true;
				}
				foreach ($all_content as $mid) {
					if (isset($want[$mid]) || isset($keep[$mid])) {
						$final[] = $mid;
					}
				}

				$row['modules'] = $final;
				$row['schema_profile'] = PageTypesConfig::normalize_schema_profile((string)($old['schema_profile'] ?? ($row['schema_profile'] ?? 'article')));
				$row['schema_mode'] = PageTypesConfig::normalize_schema_mode((string)($old['schema_mode'] ?? ($row['schema_mode'] ?? 'inherit')));
				$out[] = $row;
			}

			$options['page_types'] = $out;
		}
	}
}

