<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSaver;

final class LicenseTab
{
	public static function apply(array &$options, array $post): void
	{
		$license_key = isset($post['license_key']) ? sanitize_text_field((string)$post['license_key']) : '';
		$options['license']['key'] = $license_key;
		$options['license']['status'] = $license_key === '' ? 'unlicensed' : 'unverified';
		$options['license']['plan'] = 'free';
		$options['license']['grant_type'] = '';
		$options['license']['checked_at'] = 0;
		$options['license']['expires_at'] = 0;
		$options['license']['grace_until'] = 0;
		$options['license']['last_error'] = '';
		$options['license']['last_message'] = '';
	}
}

