<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSaver;

use ContentReady\Util\Locale;

final class BasicTab
{
	public static function apply(array &$options, array $post): void
	{
		$options['site']['display_name'] = isset($post['site_display_name']) ? sanitize_text_field((string)$post['site_display_name']) : '';
		$options['site']['logo_url'] = isset($post['site_logo_url']) ? esc_url_raw((string)$post['site_logo_url']) : '';
		$locale = isset($post['site_locale']) ? Locale::normalize_bcp47((string)$post['site_locale']) : '';
		$options['site']['locale'] = $locale;

		if (isset($post['site_entity_type'])) {
			$entity_type = sanitize_key((string)$post['site_entity_type']);
			if (!in_array($entity_type, ['organization', 'person', 'local_business'], true)) {
				$entity_type = 'organization';
			}
			$options['site']['entity_type'] = $entity_type;
		}
		if (isset($post['site_entity_name'])) {
			$options['site']['entity_name'] = sanitize_text_field((string)$post['site_entity_name']);
		}
		if (isset($post['site_entity_url'])) {
			$options['site']['entity_url'] = esc_url_raw((string)$post['site_entity_url']);
		}
		if (isset($post['site_entity_same_as'])) {
			$options['site']['entity_same_as'] = sanitize_textarea_field((string)$post['site_entity_same_as']);
		}
		if (isset($post['site_entity_phone'])) {
			$options['site']['entity_phone'] = sanitize_text_field((string)$post['site_entity_phone']);
		}
		if (isset($post['site_entity_address'])) {
			$options['site']['entity_address'] = sanitize_text_field((string)$post['site_entity_address']);
		}
		if (isset($post['site_entity_description'])) {
			$options['site']['entity_description'] = sanitize_textarea_field((string)$post['site_entity_description']);
		}

		$df_mode = isset($post['site_date_format_mode']) ? sanitize_key((string)$post['site_date_format_mode']) : 'wp';
		if ($df_mode === 'custom') {
			$options['site']['date_format'] = isset($post['site_date_format_custom']) ? sanitize_text_field((string)$post['site_date_format_custom']) : 'wp';
			if ((string)$options['site']['date_format'] === '') {
				$options['site']['date_format'] = 'wp';
			}
		} else {
			$options['site']['date_format'] = 'wp';
		}

		$author_mode = isset($post['site_author_mode']) ? sanitize_key((string)$post['site_author_mode']) : 'wp';
		if (!in_array($author_mode, ['wp', 'brand'], true)) {
			$author_mode = 'wp';
		}
		$options['site']['author_mode'] = $author_mode;
		$options['site']['brand_author_name'] = isset($post['site_brand_author_name']) ? sanitize_text_field((string)$post['site_brand_author_name']) : '';

		$options['checks']['auto_on_publish'] = !empty($post['checks_auto_on_publish']);

		if (!is_array($options['ui'] ?? null)) {
			$options['ui'] = [];
		}
		$options['ui']['editor_entry_label'] = isset($post['ui_editor_entry_label'])
			? trim(sanitize_text_field((string)$post['ui_editor_entry_label']))
			: trim((string)($options['ui']['editor_entry_label'] ?? ''));
	}
}

