<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSaver;

final class AutomationTab
{
	public static function apply(array &$options, array $post): void
	{
		$options['generation']['auto_geo_on_publish'] = !empty($post['generation_auto_geo_on_publish']);
		$options['generation']['backfill_enabled'] = !empty($post['generation_backfill_enabled']);
		$bf_mode = isset($post['generation_backfill_mode']) ? sanitize_key((string)$post['generation_backfill_mode']) : 'once';
		if (!in_array($bf_mode, ['once', 'daily'], true)) {
			$bf_mode = 'once';
		}
		$options['generation']['backfill_mode'] = $bf_mode;
		$bf_limit = isset($post['generation_backfill_daily_limit']) ? (int)$post['generation_backfill_daily_limit'] : 10;
		$options['generation']['backfill_daily_limit'] = max(1, min(200, $bf_limit));
		$bf_hour = isset($post['generation_backfill_hour']) ? (int)$post['generation_backfill_hour'] : 3;
		$options['generation']['backfill_hour'] = max(0, min(23, $bf_hour));
	}
}

