<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSaver;

final class AiPrivacyTab
{
	public static function apply(array &$options, array $post): void
	{
		$options['ai']['base_url'] = isset($post['ai_base_url']) ? esc_url_raw((string)$post['ai_base_url']) : '';
		$options['ai']['api_key'] = isset($post['ai_api_key']) ? sanitize_text_field((string)$post['ai_api_key']) : '';
		$options['ai']['model'] = isset($post['ai_model']) ? sanitize_text_field((string)$post['ai_model']) : '';
		$ai_mode = isset($post['ai_mode']) ? sanitize_key((string)$post['ai_mode']) : 'standard';
		if (!in_array($ai_mode, ['quick', 'standard', 'high'], true)) {
			$ai_mode = 'standard';
		}
		$options['ai']['mode'] = $ai_mode;
		$timeout_sec = isset($post['ai_request_timeout_sec']) ? (int)$post['ai_request_timeout_sec'] : 90;
		$options['ai']['request_timeout_sec'] = max(20, min(300, $timeout_sec));

		$send_scope = isset($post['privacy_send_scope']) ? sanitize_key((string)$post['privacy_send_scope']) : 'full';
		if (!in_array($send_scope, ['full', 'title_summary', 'selected_modules'], true)) {
			$send_scope = 'full';
		}
		$options['privacy']['send_scope'] = $send_scope;
		$options['privacy']['telemetry_enabled'] = !empty($post['privacy_telemetry_enabled']);
	}
}
