<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSaver;

final class AdvancedTab
{
	public static function apply(array &$options, array $post): void
	{
		if (isset($post['structured_output_mode'])) {
			$mode = sanitize_key((string)$post['structured_output_mode']);
			if (!in_array($mode, ['auto', 'force', 'off'], true)) {
				$mode = 'auto';
			}
			$options['structured_output']['mode'] = $mode;
		}

		$options['uninstall']['cleanup'] = !empty($post['uninstall_cleanup']);
	}
}

