<?php

declare(strict_types=1);

namespace ContentReady\Admin;

final class SettingsForm
{
	public static function open(string $tab): void
	{
		echo '<form method="post" action="' . esc_url(admin_url('admin-post.php')) . '">';
		wp_nonce_field('cr_save_settings');
		echo '<input type="hidden" name="action" value="cr_save_settings" />';
		echo '<input type="hidden" name="cr_settings_tab" value="' . esc_attr($tab) . '" />';
	}

	public static function close(string $label = '保存设置'): void
	{
		submit_button($label);
		echo '</form>';
	}
}

