<?php

declare(strict_types=1);

namespace ContentReady\Admin\Settings;

final class StructuredOutputNormalizer
{
	public static function normalize(array $options): array
	{
		if (!is_array($options['structured_output'] ?? null)) {
			$options['structured_output'] = [];
		}

		$so = $options['structured_output'];
		$so['enabled'] = !empty($so['enabled']);

		$mode = sanitize_key((string)($so['mode'] ?? 'auto'));
		if (!in_array($mode, ['auto', 'force', 'off'], true)) {
			$mode = 'auto';
		}
		$so['mode'] = $mode;

		$default_scopes = [
			'home' => 'inherit',
			'singular_post' => 'inherit',
			'singular_page' => 'inherit',
			'singular_cpt' => 'inherit',
			'taxonomy' => 'inherit',
			'search' => 'inherit',
		];

		$scopes_in = is_array($so['scopes'] ?? null) ? $so['scopes'] : [];
		$scopes = [];
		foreach ($default_scopes as $id => $default_mode) {
			$raw = isset($scopes_in[$id]) ? sanitize_key((string)$scopes_in[$id]) : $default_mode;
			if (!in_array($raw, ['inherit', 'auto', 'force', 'off'], true)) {
				$raw = $default_mode;
			}
			$scopes[$id] = $raw;
		}
		// 保留第三方扩展 scope（仅收敛值域）。
		foreach ($scopes_in as $id => $raw) {
			$id = sanitize_key((string)$id);
			if ($id === '' || isset($scopes[$id])) {
				continue;
			}
			$raw = sanitize_key((string)$raw);
			if (!in_array($raw, ['inherit', 'auto', 'force', 'off'], true)) {
				continue;
			}
			$scopes[$id] = $raw;
		}
		$so['scopes'] = $scopes;

		$default_objects = [
			'site_graph' => true,
			'webpage' => true,
			'article' => true,
			'faq' => true,
		];
		$objects_in = is_array($so['objects'] ?? null) ? $so['objects'] : [];
		$objects = [];
		foreach ($default_objects as $id => $default_enabled) {
			if (array_key_exists($id, $objects_in)) {
				$objects[$id] = !empty($objects_in[$id]);
				continue;
			}
			$objects[$id] = $default_enabled;
		}
		// 保留第三方扩展对象（布尔化）。
		foreach ($objects_in as $id => $val) {
			$id = sanitize_key((string)$id);
			if ($id === '' || isset($objects[$id])) {
				continue;
			}
			$objects[$id] = !empty($val);
		}
		$so['objects'] = $objects;

		$options['structured_output'] = $so;
		return $options;
	}
}

