<?php

declare(strict_types=1);

namespace ContentReady\Admin\Settings;

use ContentReady\Admin\Settings as RootSettings;
use ContentReady\Admin\SettingsPage;

final class PageEntry
{
	public static function render(): void
	{
		if (!current_user_can('manage_options')) {
			wp_die(esc_html__('You do not have permission to access this page.', 'content-ready'));
		}

		$notice = isset($_GET['cr_notice']) ? sanitize_text_field((string)$_GET['cr_notice']) : '';
		$options = RootSettings::get_options();
		$tab = isset($_GET['tab']) ? sanitize_key((string)$_GET['tab']) : 'basic';

		// 开箱即用：未配置 AI 时，默认打开 AI 配置页（仅当用户未显式指定 tab）。
		if (!isset($_GET['tab'])) {
			$ai = is_array($options['ai'] ?? null) ? $options['ai'] : [];
			$ai_configured = trim((string)($ai['base_url'] ?? '')) !== '' && trim((string)($ai['api_key'] ?? '')) !== '' && trim((string)($ai['model'] ?? '')) !== '';
			if (!$ai_configured) {
				$tab = 'ai_privacy';
			}
		}

		SettingsPage::render($notice, $options, $tab);
	}
}

