<?php

declare(strict_types=1);

namespace ContentReady\Admin\Settings;

use ContentReady\Admin\AssessmentPage;
use ContentReady\Admin\AutomationPage;
use ContentReady\Admin\Dashboard;
use ContentReady\Admin\Settings as RootSettings;

final class Menu
{
	public static function register(): void
	{
		// 父菜单：指向 Dashboard
		add_menu_page(
			'Content Ready',
			'Content Ready',
			'manage_options',
			'content-ready',
			[Dashboard::class, 'render_page'],
			'dashicons-yes',
			58
		);

		// 子菜单：看板（与父菜单同 slug，作为默认首页）
		add_submenu_page(
			'content-ready',
			'看板',
			'看板',
			'manage_options',
			'content-ready',
			[Dashboard::class, 'render_page']
		);

		// 子菜单：自动化（放在看板下，开始评估上）
		add_submenu_page(
			'content-ready',
			'自动化',
			'自动化',
			'manage_options',
			'content-ready-automation',
			[AutomationPage::class, 'render_page']
		);

		// 子菜单：开始评估
		add_submenu_page(
			'content-ready',
			'开始评估',
			'开始评估',
			'manage_options',
			'content-ready-assessment',
			[AssessmentPage::class, 'render_page']
		);

		// 子菜单：设置
		add_submenu_page(
			'content-ready',
			'设置',
			'设置',
			'manage_options',
			'content-ready-settings',
			[RootSettings::class, 'render_page']
		);
	}
}

