<?php

declare(strict_types=1);

namespace ContentReady\Admin\Settings;

use ContentReady\Modules\Config as ModulesConfig;
use ContentReady\PageTypes\Config as PageTypesConfig;

final class Defaults
{
	public static function maybe_seed_defaults(string $option_key, array $default_options): void
	{
		if (get_option($option_key, null) !== null) {
			return;
		}

		add_option($option_key, $default_options, '', false);
	}

	public static function build(int $config_version): array
	{
		return [
			'config_version' => $config_version,
			'checks' => [
				'auto_on_publish' => true,
			],
			'ui' => [
				'editor_entry_label' => '内容就绪',
			],
			'site' => [
				'display_name' => '',
				'logo_url' => '',
				'locale' => '',
				'date_format' => 'wp', // wp | PHP date() format
				'author_mode' => 'wp', // wp | brand
				'brand_author_name' => '',
				'entity_type' => 'organization', // organization | person | local_business（Pro）
				'entity_name' => '',
				'entity_url' => '',
				'entity_same_as' => '', // 每行一个 URL
				'entity_phone' => '',
				'entity_address' => '',
				'entity_description' => '',
			],
			'license' => [
				'key' => '',
				'status' => 'unlicensed', // unlicensed | unverified | active | disabled | invalid_key | invalid_domain | error
				'plan' => 'free', // free | pro | max
				'grant_type' => '', // paid | gift | promo | internal（服务端下发，仅用于展示/统计）
				'base_domain' => '',
				'checked_at' => 0,
				'expires_at' => 0,
				'ttl_sec' => 0,
				'grace_sec' => 0,
				'grace_until' => 0,
				'last_ok_at' => 0,
				'last_ok_plan' => '',
				'last_http_status' => 0,
				'last_error' => '',
				'last_message' => '',
			],
			'ai' => [
				'base_url' => '',
				'api_key' => '',
				'model' => '',
				'mode' => 'standard',
				'request_timeout_sec' => 90,
				'probe_last_at' => 0,
				'probe_last_ok' => false,
				'probe_last_message' => '',
			],
			'generation' => [
				'adaptive_enabled' => false, // Pro：自适应模块调用（解决模块过多导致结构膨胀）
				'dispatch_mode' => 'off', // off | adaptive | lightweight（Pro）
				'auto_geo_on_publish' => false, // Pro：发布时自动 GEO（异步）
				'backfill_enabled' => false, // Pro：老文章回填
				'backfill_mode' => 'once', // once | daily
				'backfill_daily_limit' => 10,
				'backfill_hour' => 3, // 建议执行时段（0-23）
			],
			'privacy' => [
				'send_scope' => 'full', // full | title_summary | selected_modules
				'telemetry_enabled' => true, // 匿名安装统计（仅用于统计安装量/活跃量）
			],
			'uninstall' => [
				'cleanup' => false,
			],
			'frontend' => [
				'inject_enabled' => true,
				'css_enabled' => true,
			],
			'structured_output' => [
				'enabled' => true,
				'mode' => 'auto', // auto | force | off
				// 哪些页面范围由本插件接管结构化输出（更细粒度开关）。
				// 值：inherit | auto | force | off（force 为 Pro-only）。
				'scopes' => [
					'home' => 'inherit',
					'singular_post' => 'inherit',
					'singular_page' => 'inherit',
					'singular_cpt' => 'inherit',
					'taxonomy' => 'inherit',
					'search' => 'inherit',
				],
				// 输出哪些结构化对象（Schema）。
				'objects' => [
					'site_graph' => true, // Organization + WebSite
					'webpage' => true, // WebPage
					'article' => true, // Article
					'faq' => true, // FAQPage（由模块数据驱动）
				],
			],
			'site_entrances' => [
				'llms_enabled' => false,
				'wp_sitemap_control_enabled' => false,
				'wp_sitemap_include_posts' => true,
				'wp_sitemap_include_pages' => true,
				'wp_sitemap_include_tags' => false,
				'wp_sitemap_include_users' => false,
				'recommended_urls' => '',
			],
			'modules_order' => ModulesConfig::default_order(),
			'modules' => ModulesConfig::default_modules_config(),
			'page_types' => PageTypesConfig::default_page_types(),
		];
	}
}

