<?php

declare(strict_types=1);

namespace ContentReady\Admin\Settings;

final class Assets
{
	public static function enqueue_assets(string $hook): void
	{
		$is_settings = strpos($hook, 'content-ready-settings') !== false;
		$is_assessment = strpos($hook, 'content-ready-assessment') !== false;
		$is_automation = strpos($hook, 'content-ready-automation') !== false;
		if (!$is_settings && !$is_assessment && !$is_automation) {
			return;
		}

		wp_enqueue_style(
			'content-ready-badges',
			CR_PLUGIN_URL . 'assets/badges.css',
			[],
			(string)(filemtime(CR_PLUGIN_DIR . 'assets/badges.css') ?: CR_VERSION)
		);

		// settings/automation：共用的站长向样式（卡片等）
		if ($is_settings || $is_automation) {
			wp_enqueue_style(
				'content-ready-admin-settings-page',
				CR_PLUGIN_URL . 'assets/admin-settings-page.css',
				[],
				(string)(filemtime(CR_PLUGIN_DIR . 'assets/admin-settings-page.css') ?: CR_VERSION)
			);
		}

		if ($is_settings) {
			wp_enqueue_media();

			wp_enqueue_script(
				'content-ready-admin-settings',
				CR_PLUGIN_URL . 'assets/admin-settings.js',
				[],
				(string)(filemtime(CR_PLUGIN_DIR . 'assets/admin-settings.js') ?: CR_VERSION),
				true
			);

			wp_enqueue_style(
				'content-ready-admin-modules-cards',
				CR_PLUGIN_URL . 'assets/admin-modules-cards.css',
				[],
				(string)(filemtime(CR_PLUGIN_DIR . 'assets/admin-modules-cards.css') ?: CR_VERSION)
			);
		}
	}
}

