<?php

declare(strict_types=1);

namespace ContentReady\Admin\JsonLdProbe;

final class StatusStore
{
	public static function write_scope_status(
		string $status_transient_key,
		string $scope,
		string $mode,
		bool $would_output,
		string $blocked_reason,
		int $other_scripts
	): void {
		$scope = sanitize_key((string)$scope);
		if ($scope === '') {
			return;
		}

		$now = time();
		$data = get_transient($status_transient_key);
		$data = is_array($data) ? $data : [];
		$scopes = is_array($data['scopes'] ?? null) ? $data['scopes'] : [];

		$scopes[$scope] = [
			'checked_at' => $now,
			'mode' => sanitize_key((string)$mode),
			'would_output' => $would_output ? 1 : 0,
			'blocked_reason' => sanitize_key((string)$blocked_reason),
			'other_scripts' => max(0, (int)$other_scripts),
		];

		$data['scopes'] = $scopes;
		$data['updated_at'] = $now;
		set_transient($status_transient_key, $data, 7 * DAY_IN_SECONDS);
	}
}

