<?php

declare(strict_types=1);

namespace ContentReady\Admin\JsonLdProbe;

use ContentReady\Licensing\Capabilities;
use ContentReady\Meta\MetaStore;
use ContentReady\PageTypes\Config as PageTypesConfig;

final class ModeResolver
{
	public static function effective_mode(array $options, string $scope, int $post_id = 0): string
	{
		$so = is_array($options['structured_output'] ?? null) ? $options['structured_output'] : [];
		if (empty($so['enabled'])) {
			return 'off';
		}

		$global = sanitize_key((string)($so['mode'] ?? 'auto')); // auto | force | off
		if (!in_array($global, ['auto', 'force', 'off'], true)) {
			$global = 'auto';
		}

		$scopes = is_array($so['scopes'] ?? null) ? $so['scopes'] : [];
		$scope_mode = sanitize_key((string)($scopes[$scope] ?? 'inherit'));

		if ($scope_mode === '' || $scope_mode === 'inherit') {
			$scope_mode = $global;
		}
		if (!in_array($scope_mode, ['auto', 'force', 'off'], true)) {
			$scope_mode = $global;
		}

		$mode = $scope_mode;

		if ($post_id > 0 && in_array($scope, ['singular_post', 'singular_page', 'singular_cpt'], true)) {
			$meta = MetaStore::get($post_id);
			$page_type = sanitize_key((string)($meta['page_type'] ?? 'article'));
			$strategy = PageTypesConfig::schema_strategy_for($page_type, $options);
			$page_type_mode = PageTypesConfig::normalize_schema_mode((string)($strategy['mode'] ?? 'inherit'));
			if ($page_type_mode !== 'inherit') {
				$mode = $page_type_mode;
			}
		}

		if ($mode === 'force' && !Capabilities::is_pro($options)) {
			$mode = 'auto';
		}

		return $mode;
	}
}

