<?php

declare(strict_types=1);

namespace ContentReady\Admin\JsonLdProbe;

final class Html
{
	public static function extract_head(string $html): string
	{
		if ($html === '') {
			return '';
		}

		if (preg_match('~<head\\b[^>]*>(.*?)</head>~is', $html, $m) === 1) {
			return (string)$m[1];
		}

		return '';
	}

	public static function count_other_jsonld_scripts(string $html): int
	{
		if ($html === '') {
			return 0;
		}

		$count = 0;
		if (preg_match_all('~<script\\b[^>]*type\\s*=\\s*[\"\\\'][^\"\\\']*application/ld\\+json[^\"\\\']*[\"\\\'][^>]*>~i', $html, $m) !== false) {
			foreach ($m[0] as $tag) {
				if (stripos((string)$tag, 'data-cr-jsonld') === false) {
					$count++;
				}
			}
		}

		return $count;
	}
}

