<?php

declare(strict_types=1);

namespace ContentReady\Admin\Dashboard;

use ContentReady\Modules\Registry;

final class IssueDetector
{
	/**
	 * @param array $options
	 * @return string[]
	 */
	public static function detect(array $options): array
	{
		$issues = [];

		// AI Key 未配置
		$ai_key = (string)($options['ai']['api_key'] ?? '');
		if ($ai_key === '') {
			$issues[] = 'AI Key 未配置，无法使用 AI 生成功能。';
		}

		// AI 接口地址未配置
		$ai_url = (string)($options['ai']['base_url'] ?? '');
		if ($ai_url === '') {
			$issues[] = 'AI 接口地址未配置。';
		}

		// AI 模型未配置
		$ai_model = (string)($options['ai']['model'] ?? '');
		if ($ai_model === '') {
			$issues[] = 'AI 模型未配置。';
		}

		// 没有启用任何模块
		$modules_config = is_array($options['modules'] ?? null) ? $options['modules'] : [];
		$any_enabled = false;
		foreach (Registry::all_ids() as $module_id) {
			$cfg = is_array($modules_config[$module_id] ?? null) ? $modules_config[$module_id] : [];
			if (!empty($cfg['enabled'])) {
				$any_enabled = true;
				break;
			}
		}
		if (!$any_enabled) {
			$issues[] = '没有启用任何模块，请在设置中启用至少一个模块。';
		}

		return $issues;
	}
}

