<?php

declare(strict_types=1);

namespace ContentReady\Admin;

final class AiProviderLinks
{
	/**
	 * @return array<int, array{label:string,url:string}>
	 */
	public static function links(): array
	{
		if (!defined('CR_PLUGIN_DIR')) {
			return [];
		}

		$path = rtrim((string)CR_PLUGIN_DIR, '/\\') . DIRECTORY_SEPARATOR . 'ad.md';
		if (!is_file($path) || !is_readable($path)) {
			return [];
		}

		$raw = file_get_contents($path);
		if (!is_string($raw) || $raw === '') {
			return [];
		}

		// 仅解析最简单、最安全的格式：Markdown 链接 `- [label](https://url)`
		// 其它内容允许存在（说明/注释），但会被忽略，避免站长误改导致页面报错。
		$raw = str_replace(["\r\n", "\r"], "\n", $raw);
		$lines = explode("\n", $raw);

		$out = [];
		foreach ($lines as $line) {
			if (count($out) >= 3) {
				break;
			}

			$line = trim((string)$line);
			if ($line === '') {
				continue;
			}

			$m = [];
			$ok = preg_match('/^\s*[-*]?\s*\[([^\]]+)\]\((https?:\/\/[^)\s]+)\)\s*(?:[:：\-]\s*.*)?$/u', $line, $m);
			if ($ok !== 1) {
				continue;
			}

			$label = trim((string)($m[1] ?? ''));
			$url = trim((string)($m[2] ?? ''));
			if ($label === '' || $url === '') {
				continue;
			}

			$out[] = [
				'label' => $label,
				'url' => $url,
			];
		}

		return $out;
	}
}
