(function () {
	function modules(ctx) {
		var el = ctx.el;
		var PanelBody = ctx.PanelBody;
		var Button = ctx.Button;
		var Spinner = ctx.Spinner;
		var SelectControl = ctx.SelectControl;
		var TextareaControl = ctx.TextareaControl;
		var TextControl = ctx.TextControl;
		var busy = ctx.busy || null;
		var caps =
			(ctx.payload && ctx.payload.options && ctx.payload.options.capabilities) || {};
		var features = (caps && caps.features) || {};
		var modulePlans = (caps && caps.modules) || {};
		var canSingleGenerate = !!features.single_module_generate;
		var canApplySlug = !!features.apply_slug;

		function openProUpsell(feature) {
			if (window.CR_PRO_UPSELL && window.CR_PRO_UPSELL.open) {
				window.CR_PRO_UPSELL.open({ feature: feature || '' });
				return true;
			}
			window.alert('该功能为 Pro 专属：' + (feature || '') + '。');
			return true;
		}

		function badge(kind, title, text) {
			return el('span', { className: 'cr-badge cr-badge--' + kind, title: title || '' }, text || (kind === 'pro' ? 'PRO' : 'AI'));
		}
		function proBadge(title) {
			return badge('pro', title || 'Pro 功能', 'PRO');
		}
		function aiBadge(title) {
			return badge('ai', title || '将消耗 AI Token', 'AI');
		}

		return el(
			PanelBody,
			{ title: '模块', initialOpen: true },
			ctx.moduleIds.map(function (id) {
				var st = ctx.moduleStatus(ctx.modules[id]);
				var isReadonly = id === 'last_updated' || id === 'slug_suggestions';
				var cfg = (ctx.payload && ctx.payload.options && ctx.payload.options.modules && ctx.payload.options.modules[id]) || {};
				var canGenerate = !!(cfg && cfg.allow_ai);
				var label = (cfg && cfg.label) || id;
				var isProModule = modulePlans && modulePlans[id] === 'pro';
				var usesAi = id !== 'last_updated' && canGenerate;
				var isGeneratingOne = !!(busy && busy.kind === 'generate_one' && busy.moduleId === id);
				var generateLabel = isGeneratingOne ? '正在生成…' : st === '缺失' ? '生成' : '重新生成';

				if (id === 'slug_suggestions') {
					var post = ctx.post || {};
					var cur = (post && post.slug) || '';
					var status = (post && post.status) || '';
					var suggestions =
						(ctx.modules &&
							ctx.modules[id] &&
							ctx.modules[id].data &&
							Array.isArray(ctx.modules[id].data.suggestions) &&
							ctx.modules[id].data.suggestions) ||
						[];
					var options = suggestions.map(function (s) {
						return { label: s, value: s };
					});
					var canApply = !!(ctx.slugInput && String(ctx.slugInput).trim() && String(ctx.slugInput).trim() !== cur);

					return el(
						'div',
						{ key: id, id: 'cr-editor-module-' + id, style: { marginBottom: '16px', paddingBottom: '12px', borderBottom: '1px solid #e5e7eb' } },
						el(
							'div',
							{ style: { display: 'flex', justifyContent: 'space-between', gap: '8px' } },
							el('strong', null, label, ' ', isProModule ? proBadge('该模块为 Pro 模块') : null, usesAi ? aiBadge('生成将消耗 AI Token') : null),
							el('span', null, st)
						),
						el(
							'div',
							{ style: { display: 'flex', gap: '8px', alignItems: 'center', marginBottom: '8px' } },
							el(
								'span',
								{ className: 'cr-badge-wrap' },
								el(
									Button,
									{
										isSecondary: true,
										onClick: function () {
											if (!canSingleGenerate) return openProUpsell('单模块生成');
											return ctx.generateOne(id);
										},
										disabled: ctx.loading || !canGenerate,
									},
									canSingleGenerate ? generateLabel : '单模块生成（Pro）'
								),
								proBadge('单模块生成为 Pro 功能'),
								usesAi ? aiBadge('生成将消耗 AI Token') : null
							),
							canSingleGenerate && isGeneratingOne ? el(Spinner, null) : null,
							!canGenerate ? el('span', { style: { color: '#6b7280' } }, '未允许生成') : null
						),
						st === '已修改' && canGenerate
							? el('p', { style: { color: '#6b7280', marginTop: 0 } }, '提示：重新生成会覆盖你的手动编辑。')
							: null,
						el('p', { style: { color: '#6b7280', marginTop: 0 } }, '当前 slug：' + (cur || '（空）') + (status ? '｜状态：' + status : '')),
						options.length
							? el(SelectControl, {
								label: '候选（5 个）',
								value: String(ctx.slugInput || ''),
								options: options,
								onChange: function (v) {
									ctx.setSlugInput(v || '');
								},
							})
							: el('p', { style: { color: '#6b7280' } }, '暂无候选：请先生成一次。'),
						el(TextControl, {
							label: '待应用 slug',
							value: String(ctx.slugInput || ''),
							onChange: function (v) {
								ctx.setSlugInput(v || '');
							},
							help: status === 'publish' ? '提示：本文已发布，修改 slug 可能影响 SEO。' : undefined,
						}),
						el(
							'span',
							{ className: 'cr-badge-wrap' },
							el(
								Button,
								{
									isPrimary: true,
									disabled: ctx.loading || !canApply,
									onClick: function () {
										if (!canApplySlug) return openProUpsell('一键应用 slug');
										var v = String(ctx.slugInput || '').trim();
										if (!v) return;
										var ack = false;
										if (status === 'publish') {
											ack = window.confirm('本文已经发布，修改 slug 可能影响 SEO，是否确定应用 slug？');
											if (!ack) return;
										}
										ctx.applySlug(v, ack);
									},
								},
								'应用 slug'
							),
							proBadge('一键应用 slug 为 Pro 功能')
						),
						!canApplySlug ? el('p', { style: { color: '#6b7280', marginTop: '6px' } }, '提示：一键应用 slug 为 Pro 功能。') : null
					);
				}

				return el(
					'div',
					{ key: id, id: 'cr-editor-module-' + id, style: { marginBottom: '16px', paddingBottom: '12px', borderBottom: '1px solid #e5e7eb' } },
					el(
						'div',
						{ style: { display: 'flex', justifyContent: 'space-between', gap: '8px' } },
						el('strong', null, label, ' ', isProModule ? proBadge('该模块为 Pro 模块') : null, usesAi ? aiBadge('生成将消耗 AI Token') : null),
						el('span', null, st)
					),
					el(
						'div',
						{ style: { display: 'flex', gap: '8px', alignItems: 'center', marginBottom: '6px' } },
						el(
							'span',
							{ className: 'cr-badge-wrap' },
							el(
								Button,
								{
									isSecondary: true,
									onClick: function () {
										if (!canSingleGenerate) return openProUpsell('单模块生成');
										return ctx.generateOne(id);
									},
									disabled: ctx.loading || !canGenerate,
								},
								canSingleGenerate ? generateLabel : '单模块生成（Pro）'
							),
							proBadge('单模块生成为 Pro 功能'),
							usesAi ? aiBadge('生成将消耗 AI Token') : null
						),
						canSingleGenerate && isGeneratingOne ? el(Spinner, null) : null,
						!canGenerate ? el('span', { style: { color: '#6b7280' } }, '未允许生成') : null
					),
					st === '已修改' && canGenerate
						? el('p', { style: { color: '#6b7280', marginTop: 0 } }, '提示：重新生成会覆盖你的手动编辑。')
						: null,
					el(TextareaControl, {
						label: '内容（v1 简化编辑）',
						value: ctx.drafts[id] || '',
						onChange: function (v) {
							ctx.setDrafts(
								Object.assign({}, ctx.drafts, (function () {
									var o = {};
									o[id] = v;
									return o;
								})())
							);
						},
						disabled: isReadonly,
						help:
							id === 'faq'
								? '每行：问题|回答'
								: id === 'references'
									? '每行：标题|URL'
									: id === 'table'
										? '可选注释行：# caption: 表格标题 / # notes: 备注；第一行表头（列1|列2），后续每行一行数据。'
										: undefined,
					}),
					el(Button, { isPrimary: true, onClick: function () { return ctx.saveModule(id); }, disabled: ctx.loading || isReadonly }, '保存')
				);
			})
		);
	}

	window.CR_EDITOR_SIDEBAR_MODULES_PANEL = modules;
})();
