(function () {
  if (!window.wp || !wp.apiFetch) return;
  if (!window.CR_CLASSIC || !CR_CLASSIC.postId) return;
  if (!window.CR_CLASSIC_UTILS) return;
  if (!window.CR_PAYLOAD_UTILS) return;
  if (!window.CR_CLASSIC_SLUG) return;

  var root = document.getElementById('cr-classic-root');
  if (!root) return;

  wp.apiFetch.use(wp.apiFetch.createNonceMiddleware(CR_CLASSIC.restNonce));

  function api(path, opts) {
    return wp.apiFetch(
      Object.assign(
        {
          path: '/cr/v1' + path,
        },
        opts || {}
      )
    );
  }

  function h(tag, attrs, children) {
    var el = document.createElement(tag);
    attrs = attrs || {};
    Object.keys(attrs).forEach(function (k) {
      if (attrs[k] === null || attrs[k] === undefined || attrs[k] === false) return;
      if (k === 'className') el.className = attrs[k];
      else if (k === 'text') el.textContent = attrs[k];
      else if (k === 'disabled') el.disabled = !!attrs[k];
      else el.setAttribute(k, attrs[k]);
    });
    (children || []).forEach(function (c) {
      if (typeof c === 'string') el.appendChild(document.createTextNode(c));
      else if (c) el.appendChild(c);
    });
    return el;
  }

  var encodeDraft = window.CR_CLASSIC_UTILS.encodeDraft;
  var decodeDraft = window.CR_CLASSIC_UTILS.decodeDraft;
  var moduleStatus = window.CR_CLASSIC_UTILS.moduleStatus;

  var buildDrafts = window.CR_PAYLOAD_UTILS.buildDrafts;
  var getVisibleModuleIds = window.CR_PAYLOAD_UTILS.getVisibleModuleIds;
  var getGeneratableModuleIds = window.CR_PAYLOAD_UTILS.getGeneratableModuleIds;

  function render(payload, drafts, setDraft) {
    root.innerHTML = '';
    var meta = (payload && payload.meta) || {};
    var modules = meta.modules || {};
    var options = (payload && payload.options) || {};
    var so = options.structured_output || {};
    var caps = options.capabilities || {};
    var features = (caps && caps.features) || {};
    var modulePlans = (caps && caps.modules) || {};
    var canSingleGenerate = !!features.single_module_generate;
    var canAuthor = !!features.author_strategy;
    var moduleIds = getVisibleModuleIds(meta, options);
    var busy = state.busy || null;
    var anyBusy = !!(busy && busy.kind);
    var isGeneratingAll = !!(busy && busy.kind === 'generate-all');

    function soModeLabel(mode) {
      mode = String(mode || 'auto');
      if (mode === 'force') return '强制输出';
      if (mode === 'off') return '关闭';
      return '智能兼容';
    }

    function badge(kind, title, text) {
      return h(
        'span',
        {
          className: 'cr-badge cr-badge--' + kind,
          title: title,
          text: text || (kind === 'pro' ? 'PRO' : 'AI'),
        },
        []
      );
    }

    var aiPossible = false;
    moduleIds.forEach(function (id) {
      var cfg0 = (options.modules && options.modules[id]) || {};
      if (cfg0 && cfg0.allow_ai && id !== 'last_updated') aiPossible = true;
    });

    var header = h('div', {}, [
      h('div', { className: 'cr-classic-actions' }, [
        h('button', {
          type: 'button',
          className: 'button',
          id: 'cr-classic-refresh',
          text: '刷新',
          disabled: anyBusy,
        }),
        h('span', { className: 'cr-badge-wrap' }, [
          h('button', {
            type: 'button',
            className: 'button button-primary',
            id: 'cr-classic-generate',
            text: isGeneratingAll ? '正在生成…' : '生成 GEO',
            disabled: anyBusy,
          }),
          aiPossible ? badge('ai', '生成将消耗 AI Token', 'AI') : null,
        ]),
        h('button', {
          type: 'button',
          className: 'button',
          id: 'cr-classic-preview-jsonld',
          text: '结构化预览（排查）',
          disabled: anyBusy,
        }),
        h('button', {
          type: 'button',
          className: 'button',
          id: 'cr-classic-check',
          text: '发布前检查',
          disabled: anyBusy,
        }),
        CR_CLASSIC.settingsUrl
          ? h('button', {
              type: 'button',
              className: 'button',
              id: 'cr-classic-settings',
              text: '打开设置页',
            })
          : null,
      ]),
    ]);

    var noticeText = '';
    var checkedAt = (meta.compat && meta.compat.checked_at) || 0;
    var conflict = meta.compat && meta.compat.jsonld_conflict;
    if (conflict && so && so.enabled && so.mode === 'auto') {
      noticeText =
        '检测到站点已有其他结构化输出（可能来自 SEO 插件/主题）：为避免重复，当前“智能兼容”已暂停本插件结构化输出（前端模块不受影响）。如需由本插件输出：请关闭其它来源的结构化输出（Schema/JSON-LD），或切到“强制输出”（Pro）。';
    }
    if (noticeText) {
      header.appendChild(h('p', { style: 'color:#b45309', text: noticeText }));
    }

    var counts = { gen: 0, edited: 0, missing: 0 };
    moduleIds.forEach(function (id) {
      var st = moduleStatus(modules[id]);
      if (st === '已生成') counts.gen++;
      else if (st === '已修改') counts.edited++;
      else counts.missing++;
    });
    header.appendChild(
      h('p', {
        style: 'margin:6px 0 0;',
        text:
          '模块状态：已生成 ' +
          counts.gen +
          ' / 已修改 ' +
          counts.edited +
          ' / 缺失 ' +
          counts.missing,
      })
    );
    var v1 = meta && meta.checks && meta.checks.v1;
    if (v1 && v1.ran_at && v1.result && v1.result.summary)
      header.appendChild(
        h('p', {
          style: 'margin:6px 0 0;color:#6b7280;',
          text:
            '上次检查：' +
            new Date(v1.ran_at * 1000).toLocaleString() +
            '（未达标 ' +
            (v1.result.summary.fail || 0) +
            ' / 警告 ' +
            (v1.result.summary.warn || 0) +
            '）',
        })
      );
    header.appendChild(
      h('p', {
        style: 'margin:6px 0 0;color:#6b7280;',
        text:
          '结构化输出：' +
          (so && so.enabled ? ('启用（' + soModeLabel((so && so.mode) || 'auto') + '）') : '关闭') +
          ' / 兼容性检查：' +
          (checkedAt ? new Date(checkedAt * 1000).toLocaleString() : '未完成') +
          ' / 重复检测：' +
          (conflict ? '是（已暂停输出）' : '否'),
      })
    );
    header.appendChild(
      h('p', { id: 'cr-classic-status', style: 'margin:6px 0;display:none;', text: '' })
    );

    if (canAuthor) {
      var site = options.site || {};
      var author = meta.author || {};
      var authorMode = author.mode || 'inherit';
      var authorName = author.name || '';
      var defMode = site.author_mode || 'wp';
      var defBrandName = site.brand_author_name || site.display_name || '';
      var defHint =
        defMode === 'brand'
          ? '站点默认：品牌/团队（' + (defBrandName || '未设置名称') + '）'
          : '站点默认：WordPress 作者';

      var modeSelect = h('select', { id: 'cr-classic-author-mode', style: 'width:100%;' }, [
        h('option', { value: 'inherit', text: '跟随站点默认' }),
        h('option', { value: 'wp', text: 'WordPress 作者' }),
        h('option', { value: 'brand', text: '站点品牌 / 团队' }),
      ]);
      modeSelect.value = authorMode;
      var nameInput = h(
        'input',
        {
          type: 'text',
          id: 'cr-classic-author-name',
          style: 'width:100%;',
          placeholder: '留空则使用站点默认品牌作者名称',
        },
        []
      );
      nameInput.value = authorName;
      header.appendChild(
        h('div', { style: 'margin:8px 0;padding:8px;border:1px solid #e5e7eb;background:#fff;' }, [
          h('p', {
            style: 'margin:0 0 6px;color:#111827;font-weight:600;',
          }, [
            '作者策略（结构化输出） ',
            badge('pro', '作者策略为 Pro 功能', 'PRO'),
          ]),
          h('p', { style: 'margin:0 0 6px;color:#6b7280;', text: defHint }),
          modeSelect,
          h(
            'div',
            {
              id: 'cr-classic-author-name-wrap',
              style: authorMode === 'brand' ? 'margin-top:6px;' : 'display:none;margin-top:6px;',
            },
            [nameInput]
          ),
          h('div', { style: 'margin-top:6px;display:flex;gap:8px;align-items:center;' }, [
            h('span', { className: 'cr-badge-wrap' }, [
              h('button', {
                type: 'button',
                className: 'button',
                id: 'cr-classic-save-author',
                text: '保存作者策略',
              }),
              badge('pro', '作者策略为 Pro 功能', 'PRO'),
            ]),
          ]),
        ])
      );
    } else {
      header.appendChild(
        h(
          'p',
          { style: 'margin:6px 0 0;color:#6b7280;' },
          ['作者策略：', badge('pro', '作者策略为 Pro 功能', 'PRO'), ' Free 固定使用 WordPress 作者。']
        )
      );
    }

    root.appendChild(header);

    root.appendChild(h('div', { id: 'cr-classic-check-result', style: 'margin:8px 0;' }, []));
    root.appendChild(h('div', { id: 'cr-classic-structured-preview', style: 'margin:8px 0;' }, []));

    moduleIds.forEach(function (id) {
      var st = moduleStatus(modules[id]);
      var isReadonly = id === 'last_updated' || id === 'slug_suggestions';
      var cfg = (options.modules && options.modules[id]) || {};
      var canGenerate = !!(cfg && cfg.allow_ai);
      var label = (cfg && cfg.label) || id;
      var isProModule = modulePlans && modulePlans[id] === 'pro';
      var usesAi = id !== 'last_updated' && canGenerate;
      var isGeneratingOne = !!(busy && busy.kind === 'generate-one' && busy.moduleId === id);
      var generateLabel = isGeneratingOne ? '正在生成…' : st === '缺失' ? '生成' : '重新生成';
      var buttonText = canSingleGenerate ? generateLabel : '单模块生成（Pro）';

      if (id === 'slug_suggestions') {
        var boxSlug = window.CR_CLASSIC_SLUG.renderModule(
          h,
          state,
          payload,
          id,
          label,
          st,
          canGenerate
        );
        if (boxSlug) root.appendChild(boxSlug);
        return;
      }
      var box = h(
        'div',
        { className: 'cr-classic-module', id: 'cr-classic-module-' + id, 'data-module-id': id },
        [
          h('div', { className: 'cr-classic-module__head' }, [
            h('strong', {}, [
              label,
              ' ',
              isProModule ? badge('pro', '该模块为 Pro 模块', 'PRO') : null,
              usesAi ? badge('ai', '生成将消耗 AI Token', 'AI') : null,
            ]),
            h('span', { text: st }),
          ]),
          h('textarea', {
            rows: 6,
            style: 'width:100%;box-sizing:border-box;margin-top:6px;',
            'data-module-id': id,
          }),
          h('div', { style: 'display:flex;gap:8px;margin-top:6px;align-items:center;' }, [
            h('span', { className: 'cr-badge-wrap' }, [
              h('button', {
                type: 'button',
                className: 'button',
                'data-generate-one': id,
                text: buttonText,
                disabled: anyBusy || !canGenerate,
              }),
              badge('pro', '单模块生成为 Pro 功能', 'PRO'),
              usesAi ? badge('ai', '生成将消耗 AI Token', 'AI') : null,
            ]),
            h('button', {
              type: 'button',
              className: 'button button-primary',
              'data-save-one': id,
              text: '保存',
              disabled: anyBusy,
            }),
            isReadonly ? h('span', { text: '只读', style: 'color:#6b7280;' }) : null,
            !canGenerate ? h('span', { text: '未允许生成', style: 'color:#6b7280;' }) : null,
            st === '已修改' && canGenerate
              ? h('span', { text: '提示：重新生成将覆盖已编辑', style: 'color:#6b7280;' })
              : null,
          ]),
          id === 'faq'
            ? h('p', { style: 'margin:6px 0 0;color:#6b7280;', text: 'FAQ 每行：问题|回答' })
            : id === 'references'
            ? h('p', { style: 'margin:6px 0 0;color:#6b7280;', text: 'References 每行：标题|URL' })
            : id === 'table'
            ? h('p', {
                style: 'margin:6px 0 0;color:#6b7280;',
                text: 'Table：可选 # caption: / # notes:；第一行表头（列1|列2），后续每行一行数据。',
              })
            : null,
        ]
      );

      var ta = box.querySelector('textarea');
      ta.value = drafts[id] || '';
      ta.disabled = isReadonly;
      ta.addEventListener('input', function () {
        setDraft(id, ta.value);
      });

      root.appendChild(box);
    });
  }

  var state = { payload: null, drafts: {}, busy: null };

  function setDraft(id, value) {
    state.drafts[id] = value;
  }

  function moduleLabel(id) {
    var payload = state.payload || {};
    var options = (payload && payload.options) || {};
    var cfg = (options.modules && options.modules[id]) || {};
    return (cfg && cfg.label) || id;
  }

  function isModuleEdited(id) {
    var payload = state.payload || {};
    var meta = (payload && payload.meta) || {};
    var modulesMeta = meta.modules || {};
    var m = modulesMeta && modulesMeta[id];
    return !!(m && (m.edited_at || 0) > (m.generated_at || 0));
  }

  function setStatus(text, level) {
    var el = root.querySelector('#cr-classic-status');
    if (!el) return;
    if (!text) {
      el.style.display = 'none';
      el.textContent = '';
      return;
    }
    el.style.display = 'block';
    el.style.color = level === 'error' ? '#b91c1c' : level === 'warn' ? '#b45309' : '#065f46';
    el.textContent = text;
  }

  function refresh() {
    return api('/post/' + CR_CLASSIC.postId + '/meta').then(function (res) {
      state.payload = res;
      var meta = (res && res.meta) || {};
      state.drafts = buildDrafts(meta.modules, encodeDraft);
      render(state.payload, state.drafts, setDraft);
    });
  }

  function generateAll() {
    var payload = state.payload || {};
    var meta = payload.meta || {};
    var modulesMeta = meta.modules || {};
    var options = payload.options || {};
    var moduleIds = getGeneratableModuleIds(meta, options);
    var hasEdited = moduleIds.some(function (id) {
      var m = modulesMeta && modulesMeta[id];
      return m && (m.edited_at || 0) > (m.generated_at || 0);
    });
    if (
      hasEdited &&
      !window.confirm(
        '检测到你已手动编辑过部分模块内容，继续“一键生成”可能覆盖这些模块。是否继续？'
      )
    ) {
      return null;
    }

    return api('/post/' + CR_CLASSIC.postId + '/generate', {
      method: 'POST',
      data: { only_missing: false },
    });
  }

  function generateOne(id) {
    return api('/post/' + CR_CLASSIC.postId + '/generate-module/' + id, { method: 'POST' }).then(
      refresh
    );
  }

  function saveOne(id) {
    return api('/post/' + CR_CLASSIC.postId + '/update-module/' + id, {
      method: 'POST',
      data: { data: decodeDraft(id, state.drafts[id] || '') },
    }).then(refresh);
  }

  function bind() {
    root.addEventListener('click', function (e) {
      var t = e.target;
      if (!t || t.nodeType !== 1) return;
      if (t.id === 'cr-classic-refresh') {
        e.preventDefault();
        refresh();
        return;
      }
      if (t.id === 'cr-classic-generate') {
        e.preventDefault();
        if (state.busy && state.busy.kind) return;
        state.busy = { kind: 'generate-all', moduleId: null, startedAt: Date.now() };
        render(state.payload, state.drafts, setDraft);
        setStatus('已开始生成 GEO…');
        var p = generateAll();
        if (!p || !p.then) {
          state.busy = null;
          render(state.payload, state.drafts, setDraft);
          setStatus('');
          return;
        }
        p.then(function (res) {
          var msg = (res && res.generation_message) || '生成完成。';
          return refresh().then(function () {
            return msg;
          });
        })
          .then(function (msg) {
            setStatus(msg);
            // 不自动消失，让用户有足够时间阅读
          })
          .catch(function (err) {
            setStatus('生成失败：' + ((err && err.message) || 'unknown'), 'error');
            alert((err && err.message) || '生成失败');
          })
          .finally(function () {
            state.busy = null;
            render(state.payload, state.drafts, setDraft);
          });
        return;
      }
      if (t.id === 'cr-classic-check') {
        e.preventDefault();
        if (!window.CR_CLASSIC_CHECKS) return;
        window.CR_CLASSIC_CHECKS.runCheck(api, CR_CLASSIC.postId, root).catch(function (err) {
          alert((err && err.message) || '检查失败');
        });
        return;
      }
      if (t.id === 'cr-classic-settings' && CR_CLASSIC.settingsUrl) {
        e.preventDefault();
        window.open(CR_CLASSIC.settingsUrl, '_blank');
        return;
      }
      if (t.id === 'cr-classic-save-author') {
        e.preventDefault();
        var caps = (state.payload && state.payload.options && state.payload.options.capabilities) || {};
        var features = (caps && caps.features) || {};
        if (!features.author_strategy) {
          setStatus('该功能为 Pro 专属：作者策略。', 'error');
          if (window.CR_PRO_UPSELL && window.CR_PRO_UPSELL.open) {
            window.CR_PRO_UPSELL.open({ feature: '作者策略（结构化输出）' });
          } else {
            alert('该功能为 Pro 专属：作者策略。');
          }
          return;
        }
        var modeEl = root.querySelector('#cr-classic-author-mode');
        var nameEl = root.querySelector('#cr-classic-author-name');
        var mode = modeEl ? modeEl.value : 'inherit';
        var name = nameEl ? nameEl.value : '';
        api('/post/' + CR_CLASSIC.postId + '/author', {
          method: 'POST',
          data: { mode: mode, name: name },
        })
          .then(refresh)
          .catch(function (err) {
            alert((err && err.message) || '保存失败');
          });
        return;
      }
      if (window.CR_CLASSIC_SLUG && window.CR_CLASSIC_SLUG.handleClick) {
        if (window.CR_CLASSIC_SLUG.handleClick(e, root, state, api, refresh)) {
          return;
        }
      }
      var gen = t.getAttribute('data-generate-one');
      if (gen) {
        e.preventDefault();
        var caps2 = (state.payload && state.payload.options && state.payload.options.capabilities) || {};
        var features2 = (caps2 && caps2.features) || {};
        if (!features2.single_module_generate) {
          setStatus('该功能为 Pro 专属：单模块生成。', 'error');
          if (window.CR_PRO_UPSELL && window.CR_PRO_UPSELL.open) {
            window.CR_PRO_UPSELL.open({ feature: '单模块生成' });
          } else {
            alert('该功能为 Pro 专属：单模块生成。');
          }
          return;
        }
        if (state.busy && state.busy.kind) return;
        if (
          isModuleEdited(gen) &&
          !window.confirm('检测到你已手动编辑过该模块内容，继续“重新生成”可能覆盖这些修改。是否继续？')
        ) {
          return;
        }
        var label = moduleLabel(gen);
        state.busy = { kind: 'generate-one', moduleId: gen, startedAt: Date.now() };
        render(state.payload, state.drafts, setDraft);
        setStatus('已开始生成：' + label + '…');
        generateOne(gen)
          .then(function () {
            setStatus('生成完成：' + label + '。');
          })
          .catch(function (err) {
            setStatus('生成失败：' + ((err && err.message) || 'unknown'), 'error');
            alert((err && err.message) || '生成失败');
          })
          .finally(function () {
            state.busy = null;
            render(state.payload, state.drafts, setDraft);
          });
        return;
      }
      var save = t.getAttribute('data-save-one');
      if (save) {
        e.preventDefault();
        saveOne(save).catch(function (err) {
          alert((err && err.message) || '保存失败');
        });
      }
    });

    root.addEventListener('change', function (e) {
      var t = e.target;
      if (!t || t.nodeType !== 1) return;
      if (t.id === 'cr-classic-author-mode') {
        var wrap = root.querySelector('#cr-classic-author-name-wrap');
        if (!wrap) return;
        wrap.style.display = t.value === 'brand' ? 'block' : 'none';
      }
    });
  }

  bind();
  refresh().catch(function (err) {
    root.textContent = (err && err.message) || '加载失败';
  });
})();
