(function () {
	if (!window.wp || !wp.apiFetch) return;
	if (!window.CR_CLASSIC || !CR_CLASSIC.postId) return;

	var root = document.getElementById('cr-classic-root');
	if (!root) return;

	wp.apiFetch.use(wp.apiFetch.createNonceMiddleware(CR_CLASSIC.restNonce));

	function api(path, opts) {
		return wp.apiFetch(
			Object.assign(
				{
					path: '/cr/v1' + path,
				},
				opts || {}
			)
		);
	}

	function reasonText(preview) {
		if (!preview) return '';
		var reason = preview.blocked_reason || '';
		var compat = preview.compat || {};
		if (reason === 'structured_disabled') return '结构化输出未启用或已关闭。';
		if (reason === 'not_article_page_type') return '当前页面类型（' + (preview.page_type || 'unknown') + '）暂不输出结构化。';
		if (reason === 'auto_not_checked_yet') return '智能兼容：正在检查是否与其他结构化重复，完成前暂不输出。';
		if (reason === 'auto_check_failed')
			return '智能兼容：兼容性检查失败（' + ((compat && compat.last_error) || 'unknown') + '），前端已暂停结构化输出。';
		if (reason === 'auto_conflict_detected')
			return '智能兼容：检测到页面已有其他结构化输出，为避免重复已暂停输出（如 SEO 插件/主题的 Schema/JSON-LD）。';
		if (reason === 'post_not_found') return '文章不存在或已删除。';
		return reason ? '已阻止输出：' + reason : '';
	}

	function objectsText(preview) {
		if (!preview || !Array.isArray(preview.objects) || !preview.objects.length) return '';
		return preview.objects
			.map(function (obj) {
				return JSON.stringify(obj, null, 2);
			})
			.filter(Boolean)
			.join('\n\n');
	}

	function render(box, state) {
		if (!box) return;
		box.innerHTML = '';

		function p(text, style) {
			var el = document.createElement('p');
			el.textContent = text;
			if (style) el.setAttribute('style', style);
			return el;
		}

		if (state.loading) {
			box.appendChild(p('加载中…', 'margin:6px 0;color:#6b7280;'));
			return;
		}
		if (state.error) {
			box.appendChild(p(state.error, 'margin:6px 0;color:#b91c1c;'));
			return;
		}
		if (!state.preview) {
			box.appendChild(p('点击“结构化预览（排查）”查看结构化输出预览。', 'margin:6px 0;color:#6b7280;'));
			return;
		}

		var preview = state.preview;
		var status = preview.would_output ? '前端将输出' : '前端将不输出';
		var reason = reasonText(preview);
		box.appendChild(p(status + (reason ? '｜' + reason : ''), 'margin:6px 0;'));

		if (preview.compat && preview.compat.checked_at) {
			box.appendChild(p('兼容性检查时间：' + new Date(preview.compat.checked_at * 1000).toLocaleString(), 'margin:6px 0;color:#6b7280;'));
		}

		box.appendChild(
			p('如果想由本插件负责结构化输出：请在对应 SEO 插件中关闭结构化输出（Schema/JSON-LD）（全局/该文章类型/单篇文章），或将本插件切到“强制输出”（Pro）。', 'margin:6px 0;color:#6b7280;')
		);

		var text = objectsText(preview);
		if (!text) {
			box.appendChild(p('暂无可预览对象（可能未配置 Article/FAQ，或页面类型不输出）。', 'margin:6px 0;color:#6b7280;'));
			return;
		}

		var ta = document.createElement('textarea');
		ta.value = text;
		ta.readOnly = true;
		ta.setAttribute('style', 'width:100%;min-height:240px;box-sizing:border-box;');
		box.appendChild(ta);
	}

	var state = { loading: false, error: '', preview: null };

	function runPreview() {
		state.loading = true;
		state.error = '';
		render(root.querySelector('#cr-classic-structured-preview'), state);
		return api('/post/' + CR_CLASSIC.postId + '/structured-preview', { method: 'POST' })
			.then(function (res) {
				state.preview = res || null;
			})
			.catch(function (e) {
				state.error = (e && e.message) || '预览失败';
			})
			.finally(function () {
				state.loading = false;
				render(root.querySelector('#cr-classic-structured-preview'), state);
			});
	}

	root.addEventListener('click', function (e) {
		var t = e.target;
		if (!t || t.nodeType !== 1) return;
		if (t.id !== 'cr-classic-preview-jsonld') return;
		e.preventDefault();
		runPreview();
	});

	render(root.querySelector('#cr-classic-structured-preview'), state);
})();
