(function () {
	if (window.CR_CLASSIC_SLUG) return;

	function renderModule(h, state, payload, moduleId, label, st, canGenerate) {
		var meta = (payload && payload.meta) || {};
		var modules = meta.modules || {};
		var post = (payload && payload.post) || {};
		var options = (payload && payload.options) || {};
		var caps = options.capabilities || {};
		var features = (caps && caps.features) || {};
		var canSingleGenerate = !!features.single_module_generate;
		var canApplySlug = !!features.apply_slug;
		var busy = (state && state.busy) || null;
		var anyBusy = !!(busy && busy.kind);
		var isGenerating = !!(busy && busy.kind === 'generate-one' && busy.moduleId === moduleId);

		var data = (modules[moduleId] && modules[moduleId].data) || {};
		var suggestions = Array.isArray(data.suggestions) ? data.suggestions : [];
		var curSlug = post.slug || '';
		var status = post.status || '';
		var permalink = post.permalink || '';

		var input = h('input', { type: 'text', id: 'cr-classic-slug-input', style: 'width:100%;box-sizing:border-box;margin-top:6px;' }, []);
		var initial = curSlug || state.slugInput || (suggestions && suggestions[0]) || '';
		state.slugInput = initial;
		input.value = initial;
		input.addEventListener('input', function () {
			state.slugInput = input.value;
		});

		var sugWrap = h('div', { style: 'margin-top:6px;display:flex;flex-wrap:wrap;gap:6px;' }, []);
		suggestions.forEach(function (s) {
			sugWrap.appendChild(h('button', { type: 'button', className: 'button', 'data-use-slug': s, text: s }, []));
		});

		var canApply = !!(state.slugInput && String(state.slugInput).trim() && String(state.slugInput).trim() !== curSlug);
		var generateLabel = isGenerating ? '正在生成…' : st === '缺失' ? '生成' : '重新生成';
		if (!canSingleGenerate) generateLabel = '单模块生成（Pro）';

		function badge(kind, title, text) {
			return h('span', { className: 'cr-badge cr-badge--' + kind, title: title, text: text || (kind === 'pro' ? 'PRO' : 'AI') }, []);
		}

		return h('div', { className: 'cr-classic-module', id: 'cr-classic-module-' + moduleId, 'data-module-id': moduleId }, [
			h('div', { className: 'cr-classic-module__head' }, [
				h('strong', {}, [label, ' ', badge('ai', '生成将消耗 AI Token', 'AI')]),
				h('span', { text: st }),
			]),
			h('p', { style: 'margin:6px 0 0;color:#6b7280;', text: '当前 slug：' + (curSlug || '（空）') + (status ? '｜状态：' + status : '') }),
			permalink ? h('p', { style: 'margin:6px 0 0;color:#6b7280;', text: '链接：' + permalink }) : null,
			input,
			suggestions.length ? sugWrap : h('p', { style: 'margin:6px 0 0;color:#6b7280;', text: '暂无候选：请先生成一次。' }),
			h('div', { style: 'display:flex;gap:8px;margin-top:6px;align-items:center;' }, [
				h('span', { className: 'cr-badge-wrap' }, [
					h('button', { type: 'button', className: 'button', 'data-generate-one': moduleId, text: generateLabel, disabled: anyBusy || !canGenerate }),
					badge('pro', '单模块生成为 Pro 功能', 'PRO'),
					badge('ai', '生成将消耗 AI Token', 'AI'),
				]),
				h('span', { className: 'cr-badge-wrap' }, [
					h('button', { type: 'button', className: 'button button-primary', 'data-apply-slug': '1', text: '应用 slug', disabled: anyBusy || !canApply }),
					badge('pro', '一键应用 slug 为 Pro 功能', 'PRO'),
				]),
				!canGenerate ? h('span', { text: '未允许生成', style: 'color:#6b7280;' }) : null,
				st === '已修改' && canGenerate ? h('span', { text: '提示：重新生成将覆盖已编辑', style: 'color:#6b7280;' }) : null,
			]),
			!canApplySlug ? h('p', { style: 'margin:6px 0 0;color:#6b7280;', text: '提示：一键应用 slug 为 Pro 功能。' }) : null,
			status === 'publish' ? h('p', { style: 'margin:6px 0 0;color:#b45309;', text: '提示：本文已发布，修改 slug 可能影响 SEO。' }) : null,
		]);
	}

	function handleClick(e, root, state, api, refresh) {
		var t = e.target;
		if (!t || t.nodeType !== 1) return false;

		var useSlug = t.getAttribute('data-use-slug');
		if (useSlug) {
			e.preventDefault();
			state.slugInput = useSlug;
			var inp = root.querySelector('#cr-classic-slug-input');
			if (inp) inp.value = useSlug;
			return true;
		}

		var apply = t.getAttribute('data-apply-slug');
		if (!apply) return false;

		e.preventDefault();
		var payload0 = state.payload || {};
		var options0 = (payload0 && payload0.options) || {};
		var caps0 = options0.capabilities || {};
		var features0 = (caps0 && caps0.features) || {};
		if (!features0.apply_slug) {
			if (window.CR_PRO_UPSELL && window.CR_PRO_UPSELL.open) {
				window.CR_PRO_UPSELL.open({ feature: '一键应用 slug' });
			} else {
				alert('该功能为 Pro 专属：一键应用 slug。');
			}
			return true;
		}
		var inp2 = root.querySelector('#cr-classic-slug-input');
		var slug = (inp2 && inp2.value) || state.slugInput || '';
		slug = String(slug || '').trim();
		if (!slug) return true;

		var payload = payload0 || {};
		var post = (payload && payload.post) || {};
		var status = (post && post.status) || '';
		var ack = false;
		if (status === 'publish') {
			ack = window.confirm('本文已经发布，修改 slug 可能影响 SEO，是否确定应用 slug？');
			if (!ack) return true;
		}

		api('/post/' + CR_CLASSIC.postId + '/apply-slug', { method: 'POST', data: { slug: slug || '', ack_published: !!ack } })
			.then(function (res) {
				if (res && res.applied) state.slugInput = String(res.applied);
			})
			.then(refresh)
			.catch(function (err) {
				alert((err && err.message) || '应用失败');
			});

		return true;
	}

	window.CR_CLASSIC_SLUG = {
		renderModule: renderModule,
		handleClick: handleClick,
	};
})();
