(function () {
  if (!window.wp || !wp.apiFetch) return;
  if (!window.CR_ADMIN_ASSESSMENT) return;

  var selectEl = document.getElementById('cr-assessment-post');
  var runEl = document.getElementById('cr-assessment-run');
  var statusEl = document.getElementById('cr-assessment-status');
  var resultsEl = document.getElementById('cr-assessment-results');
  if (!selectEl || !runEl || !statusEl || !resultsEl) return;

  wp.apiFetch.use(wp.apiFetch.createNonceMiddleware(CR_ADMIN_ASSESSMENT.restNonce));

  function api(path, opts) {
    return wp.apiFetch(
      Object.assign(
        {
          path: '/cr/v1' + path,
        },
        opts || {}
      )
    );
  }

  function h(tag, attrs, children) {
    var el = document.createElement(tag);
    attrs = attrs || {};
    Object.keys(attrs).forEach(function (k) {
      if (attrs[k] === null || attrs[k] === undefined || attrs[k] === false) return;
      if (k === 'className') el.className = attrs[k];
      else if (k === 'text') el.textContent = attrs[k];
      else el.setAttribute(k, attrs[k]);
    });
    (children || []).forEach(function (c) {
      if (typeof c === 'string') el.appendChild(document.createTextNode(c));
      else if (c) el.appendChild(c);
    });
    return el;
  }

  function setStatus(text, type) {
    statusEl.innerHTML = '';
    if (!text) return;
    var cls = 'notice notice-info inline';
    if (type === 'error') cls = 'notice notice-error inline';
    if (type === 'warning') cls = 'notice notice-warning inline';
    statusEl.appendChild(h('div', { className: cls }, [h('p', { text: text }, [])]));
  }

  function friendlyApiError(err) {
    var code = String((err && err.code) || '');
    if (code) {
      switch (code) {
        case 'cr_post_not_found':
          return '文章不存在或无权限';
        case 'cr_post_not_publish':
          return '请选择已发布文章';
        case 'cr_permalink_missing':
          return '未能获取文章链接（permalink）';
        default:
          break;
      }
    }

    var status = (err && err.data && err.data.status) || '';
    var msg = (err && err.message) || '';
    msg = String(msg || 'unknown');
    if (status) return msg + '（HTTP ' + status + '）';
    return msg;
  }

  function friendlyBlockedReason(code) {
    code = String(code || '');
    if (!code) return '';
    switch (code) {
      case 'structured_disabled':
        return '已关闭';
      case 'not_article_page_type':
        return '页面类型不是 article';
      case 'auto_not_checked_yet':
        return '智能兼容：正在检查是否与其他结构化重复';
      case 'auto_check_failed':
        return '智能兼容：兼容性检查失败';
      case 'auto_conflict_detected':
        return '智能兼容：检测到重复结构化输出';
      case 'post_not_found':
        return '文章不存在';
      default:
        return code;
    }
  }

  function renderResults(res) {
    resultsEl.innerHTML = '';
    if (!res) return;

    var list = [];

    list.push(
      h('div', { style: 'margin:0 0 10px;' }, [
        h('div', { style: 'font-weight:600;margin-bottom:4px;', text: '结果概览' }, []),
        h('div', { style: 'color:#6b7280;', text: (res.permalink || '') }, []),
      ])
    );

    if (res.warnings && res.warnings.length) {
      list.push(
        h('div', { className: 'notice notice-warning inline', style: 'margin:8px 0;' }, [
          h('p', { text: '提示：' }, []),
          h(
            'ul',
            { style: 'margin:6px 0 0 18px;' },
            res.warnings.map(function (w) {
              return h('li', { text: String(w || '') }, []);
            })
          ),
        ])
      );
    }

    var jsonld = res.jsonld || {};
    var so = res.structured_preview || {};
    var content = res.content || {};
    var geo = res.geo_modules || {};
    var expectedCount = parseInt(String(content.expected_enabled_modules_count || 0), 10) || 0;
    var geoGeneratedCount = (geo.generated_ids && geo.generated_ids.length) || 0;
    var geoMissingCount = (geo.missing_ids && geo.missing_ids.length) || 0;
    var geoMissingDetail = (geo.missing_detail && geo.missing_detail.length && geo.missing_detail) || [];
    var blockedLabel = friendlyBlockedReason(so.blocked_reason);

    list.push(
      h('div', { style: 'padding:12px;border:1px solid #e5e7eb;background:#fff;margin-top:10px;' }, [
        h('div', { style: 'font-weight:600;margin-bottom:6px;', text: '前端结构检查（不消耗 Token）' }, []),
        h('p', { style: 'margin:0;color:#374151;', text: 'JSON-LD 脚本：共 ' + (jsonld.total_scripts || 0) + ' 个（本插件 ' + (jsonld.cr_scripts || 0) + ' / 其他 ' + (jsonld.other_scripts || 0) + '）' }, []),
        h(
          'p',
          {
            style: 'margin:4px 0 0;color:#374151;',
            text:
              'Content Ready 模块渲染：' +
              (content.found_cr_modules
                ? '检测到（约 ' + (content.cr_module_count || 0) + ' 处）'
                : expectedCount > 0
                ? '未检测到（该文章预期有 ' + expectedCount + ' 个可展示模块）'
                : '未检测到（该文章暂无可展示模块）'),
          },
          []
        ),
        h(
          'p',
          {
            style: 'margin:4px 0 0;color:#374151;',
            text:
              'GEO 模块覆盖（推荐清单）：已生成 ' + geoGeneratedCount + ' 个 / 缺失 ' + geoMissingCount + ' 个',
          },
          []
        ),
        h(
          'p',
          {
            style: 'margin:4px 0 0;color:#374151;',
            text:
              '结构化输出（预览）：' +
              (so.would_output ? '前端会输出' : '前端不会输出') +
              (blockedLabel ? '（原因：' + blockedLabel + '）' : ''),
          },
          []
        ),
      ])
    );

    if (geoMissingDetail.length) {
      list.push(
        h('div', { style: 'padding:12px;border:1px solid #e5e7eb;background:#fff;margin-top:10px;' }, [
          h('div', { style: 'font-weight:600;margin-bottom:6px;', text: '建议优先补齐（缺失的 GEO 信号）' }, []),
          h(
            'ul',
            { style: 'margin:6px 0 0 18px;color:#374151;' },
            geoMissingDetail.map(function (m) {
              var label = String(m.label || m.id || '');
              var intro = String(m.intro || '');
              return h('li', {}, [label + (intro ? '：' + intro : '')]);
            })
          ),
          h(
            'div',
            { style: 'margin-top:8px;color:#6b7280;' },
            [
              '提示：这个清单不看“当前设置是否启用”，用于帮助你快速判断页面还缺哪些 GEO 模块。若你不想输出某些模块，可在「模块与输出」里关闭。',
            ]
          ),
        ])
      );
    }

    var suggestions = (res.suggestions && res.suggestions.length && res.suggestions) || [];
    if (suggestions.length) {
      var links = suggestions.map(function (s) {
        return h('a', { href: s.url, className: 'button', style: 'margin-right:8px;', text: s.label }, []);
      });
      list.push(h('div', { style: 'margin-top:12px;' }, links));
    }

    list.forEach(function (n) {
      resultsEl.appendChild(n);
    });
  }

  runEl.addEventListener('click', function () {
    var postId = parseInt(String(selectEl.value || ''), 10);
    if (!postId) {
      setStatus('请先选择一篇已发布文章。', 'warning');
      return;
    }

    runEl.disabled = true;
    setStatus('正在检查…', 'info');
    resultsEl.innerHTML = '';

    api('/assessment/post/' + postId, { method: 'POST' })
      .then(function (res) {
        if (res && res.warnings && res.warnings.length) setStatus('检查完成（有提示）。', 'warning');
        else setStatus('检查完成。', 'info');
        renderResults(res);
      })
      .catch(function (err) {
        setStatus('检查失败：' + friendlyApiError(err), 'error');
      })
      .finally(function () {
        runEl.disabled = false;
      });
  });
})();
