# AGENTS（Content-Ready 插件）

> 作用域：仅 `Content-Ready/` 插件运行时代码。

## 1) 职责边界

- 负责编辑器生成、前端渲染、结构化输出（JSON-LD）与 `/cr/v1` REST。
- 负责 Free/Pro 运行态能力门禁（与授权端返回结果联动）。
- 不负责 Cloudflare Worker、资讯抓取机器人与知识库文档体系。

## 2) 稳定入口

- 插件入口：`content-ready.php`
- 启动入口：`includes/autoload.php`、`includes/Plugin.php`
- 关键目录：
  - `includes/Rest/`：文章级接口
  - `includes/Generator/`：模块生成链路
  - `includes/Frontend/`：前端注入与结构化输出
  - `includes/Modules/`：模块注册与规则
  - `assets/`：后台与编辑器脚本样式

## 3) 数据与兼容约束

- `post_meta` 使用 `cr_meta_v1`（单一 JSON）。
- `wp_options` 使用 `cr_options_v1`。
- 默认不写 `post_content`，避免与主题/编辑器块直接耦合。
- 前端输出必须走受控白名单/转义，避免 XSS。

## 4) 最小验收命令

- 全量 PHP 语法检查：
  - `pwsh -NoProfile -Command "Set-Location 'd:\\github\\Content-Ready'; Get-ChildItem -Path 'Content-Ready' -Recurse -File -Filter '*.php' | Where-Object { $_.FullName -notmatch '\\vendor\\' } | ForEach-Object { php -l $_.FullName }"`
- 发包前检查：
  - `pwsh -NoProfile -File .\\release.ps1`

## 5) 失败处理硬规则（插件内）

- 插件运行时采用 **fail-fast**：失败即报错并停止，不做自动善后。
- 禁止在以下链路实现兜底：
  - AI 生成链路（自动重试、自动降级、静默跳过）
  - 自动化链路（失败后自动重排/补偿执行）
  - 后台交互链路（`catch` 后吞错、失败后隐式跳转）
- 允许保留的最小保护：
  - 权限/参数校验
  - 明确超时上限
  - 显式错误响应与可读错误提示
