<?php

declare(strict_types=1);

namespace ContentReady\Toc;

use ContentReady\Util\Anchors;
use ContentReady\Util\HtmlHeadings;

final class TocBuilder
{
	/**
	 * 从 post_content 生成 TOC 条目（仅基于正文标题，不包含注入模块）。
	 *
	 * @return array<int, array{id:string,text:string,level:int}>
	 */
	public static function build_items(string $html, array $meta): array
	{
		if ($html === '') {
			return [];
		}

		$headings = HtmlHeadings::extract($html, 2, 5);
		if ($headings === []) {
			return [];
		}

		$out = [];
		foreach ($headings as $idx => $h) {
			$level = (int)($h['level'] ?? 2);
			$text = sanitize_text_field((string)($h['text'] ?? ''));
			$existing_id = (string)($h['existing_id'] ?? '');

			if ($text === '') {
				continue;
			}

			$id = Anchors::sanitize_anchor_id($existing_id);
			if ($id === '') {
				$a = Anchors::get_heading_anchor($meta, (int)$idx);
				$id = Anchors::sanitize_anchor_id((string)($a['id'] ?? ''));
			}
			if ($id === '') {
				$slug = Anchors::sanitize_anchor_id((string)sanitize_title($text));
				$id = $slug !== '' ? $slug : ('section-' . ((int)$idx + 1));
			}

			$out[] = [
				'id' => $id,
				'text' => $text,
				'level' => max(2, min(5, $level)),
			];

			if (count($out) >= 200) {
				break;
			}
		}

		return $out;
	}
}
