<?php

declare(strict_types=1);

namespace ContentReady\Modules;

final class Registry
{
	/**
	 * 模块 ID 必须冻结、不可变（新增需走版本升级与迁移）。
	 */
	private const MODULES = [
		'summary' => [
			'label' => '摘要（Summary）',
			'intro' => '快速概览全文要点，帮助读者与搜索引擎快速理解主题。',
			'position' => 'top',
			'enabled_by_default' => false,
			'is_content' => true,
		],
		'verdict' => [
			'label' => '一句话结论',
			'intro' => '用一句话给出结论，让读者快速判断是否值得继续阅读。',
			'position' => 'top',
			'enabled_by_default' => true,
			'is_content' => true,
		],
		'tldr' => [
			'label' => '快速要点（TL;DR）',
			'intro' => '用要点总结核心信息，提升扫读体验与信息密度。',
			'position' => 'top',
			'enabled_by_default' => true,
			'is_content' => true,
		],
		'toc' => [
			'label' => '本文目录（TOC）',
			'intro' => '基于正文标题（H2-H5）自动生成可跳转的目录，提升扫读体验与可访问性。',
			'position' => 'top',
			'enabled_by_default' => false,
			'is_content' => true,
		],
		'limitations' => [
			'label' => '适用范围与限制',
			'intro' => '明确适用边界与注意事项，提升内容可信度与转化质量。',
			'position' => 'after',
			'enabled_by_default' => true,
			'is_content' => true,
		],
		'faq' => [
			'label' => '常见问题（FAQ）',
			'intro' => '补齐读者常见问答，覆盖长尾问题并增强结构化表达。',
			'position' => 'bottom',
			'enabled_by_default' => true,
			'is_content' => true,
		],
		'references' => [
			'label' => '参考资料 / 数据来源',
			'intro' => '展示来源与引用，增强内容可信度（E-E-A-T）与可追溯性。',
			'position' => 'bottom',
			'enabled_by_default' => true,
			'is_content' => true,
		],
		'last_updated' => [
			'label' => '可见更新时间',
			'intro' => '展示更新信息，帮助读者判断内容是否仍然有效。',
			'position' => 'bottom',
			'enabled_by_default' => true,
			'is_content' => true,
		],
		'table' => [
			'label' => '表格（Table）',
			'intro' => '用表格进行归纳与对比，提升可读性与信息密度（默认优先贴近最相关的小节，避免出现在文章开头）。',
			'position' => 'after',
			'enabled_by_default' => false,
			'is_content' => true,
		],
		'slug_suggestions' => [
			'label' => 'Slug 推荐（仅编辑器）',
			'intro' => '提供更清晰的链接别名建议，便于 SEO 与分享。',
			'position' => 'bottom',
			'enabled_by_default' => false,
			'is_content' => true,
		],
		'anchors' => [
			'label' => '稳定锚点',
			'position' => 'code',
			'enabled_by_default' => true,
			'is_content' => false,
		],
		'structured_output' => [
			'label' => '结构化输出（代码层）',
			'position' => 'code',
			'enabled_by_default' => true,
			'is_content' => false,
		],
	];

	public static function all(): array
	{
		return self::MODULES;
	}

	public static function all_ids(): array
	{
		return array_keys(self::MODULES);
	}

	public static function is_valid_id(string $module_id): bool
	{
		return isset(self::MODULES[$module_id]);
	}

	public static function is_content_module(string $module_id): bool
	{
		return (bool)(self::MODULES[$module_id]['is_content'] ?? false);
	}
}

