<?php

declare(strict_types=1);

namespace ContentReady\Licensing;

use ContentReady\Admin\Settings;

/**
 * Pro 敏感动作门禁（统一入口）：
 * - 可按需/强制触发一次在线校验（用于“禁用立即生效”）
 * - 校验结果落盘后，再读取规范化 options
 */
final class LicenseGate
{
	/**
	 * @return bool refreshed
	 */
	public static function refresh_and_persist(bool $force, string $context): bool
	{
		$raw = Settings::get_raw_options();
		[$raw, $refreshed] = LicenseClient::maybe_refresh($raw, [
			'force' => $force,
			'context' => $context,
		]);
		if ($refreshed) {
			Settings::update_options($raw);
		}

		return $refreshed;
	}

	public static function options(bool $force, string $context): array
	{
		self::refresh_and_persist($force, $context);
		return Settings::get_options();
	}
}

