<?php

declare(strict_types=1);

namespace ContentReady\Editor;

use ContentReady\Admin\Settings;

final class Gutenberg
{
	public static function register(): void
	{
		add_action('enqueue_block_editor_assets', [self::class, 'enqueue_assets']);
	}

	public static function enqueue_assets(): void
	{
		$options = Settings::get_options();
		$ui = is_array($options['ui'] ?? null) ? $options['ui'] : [];
		$ui_label = trim(sanitize_text_field((string)($ui['editor_entry_label'] ?? '')));
		if ($ui_label === '') {
			$ui_label = '内容就绪';
		}

		wp_enqueue_script(
			'content-ready-pro-upsell',
			CR_PLUGIN_URL . 'assets/pro-upsell.js',
			[],
			(string)(filemtime(CR_PLUGIN_DIR . 'assets/pro-upsell.js') ?: CR_VERSION),
			true
		);

		wp_enqueue_style(
			'content-ready-pro-upsell',
			CR_PLUGIN_URL . 'assets/pro-upsell.css',
			[],
			(string)(filemtime(CR_PLUGIN_DIR . 'assets/pro-upsell.css') ?: CR_VERSION)
		);

		wp_enqueue_script(
			'content-ready-editor-utils',
			CR_PLUGIN_URL . 'assets/editor-utils.js',
			[],
			CR_VERSION,
			true
		);

		wp_enqueue_script(
			'content-ready-payload-utils',
			CR_PLUGIN_URL . 'assets/payload-utils.js',
			[],
			CR_VERSION,
			true
		);

		wp_enqueue_script(
			'content-ready-editor-checks',
			CR_PLUGIN_URL . 'assets/editor-checks.js',
			[],
			CR_VERSION,
			true
		);

		wp_enqueue_script(
			'content-ready-editor-sidebar',
			CR_PLUGIN_URL . 'assets/editor-sidebar.js',
			['content-ready-editor-utils', 'content-ready-payload-utils', 'content-ready-editor-checks'],
			CR_VERSION,
			true
		);

		wp_localize_script('content-ready-editor-sidebar', 'CR_EDITOR_SIDEBAR_CFG', [
			'uiLabel' => $ui_label,
		]);

		wp_enqueue_script(
			'content-ready-editor-sidebar-modules-panel',
			CR_PLUGIN_URL . 'assets/editor-sidebar-modules-panel.js',
			['content-ready-pro-upsell'],
			CR_VERSION,
			true
		);

		wp_enqueue_script(
			'content-ready-editor-sidebar-panels',
			CR_PLUGIN_URL . 'assets/editor-sidebar-panels.js',
			['content-ready-editor-sidebar-modules-panel'],
			CR_VERSION,
			true
		);

		$handle = 'content-ready-editor';
		wp_enqueue_script(
			$handle,
			CR_PLUGIN_URL . 'assets/editor.js',
			['content-ready-editor-sidebar-panels', 'content-ready-editor-sidebar', 'wp-plugins', 'wp-edit-post', 'wp-element', 'wp-components', 'wp-data', 'wp-api-fetch'],
			CR_VERSION,
			true
		);

		wp_localize_script($handle, 'CR_EDITOR', [
			'settingsUrl' => admin_url('admin.php?page=content-ready-settings'),
			'licenseUrl' => admin_url('admin.php?page=content-ready-settings&tab=license'),
			'proBuyUrl' => apply_filters('cr_pro_buy_url', 'https://xmtbx.com/content-ready'),
		]);

		wp_enqueue_style(
			'content-ready-badges',
			CR_PLUGIN_URL . 'assets/badges.css',
			[],
			CR_VERSION
		);

		wp_enqueue_style(
			'content-ready-editor',
			CR_PLUGIN_URL . 'assets/editor.css',
			[],
			CR_VERSION
		);
	}
}
