<?php

declare(strict_types=1);

namespace ContentReady\Anchors;

use ContentReady\Admin\Settings;
use ContentReady\Meta\MetaStore;
use ContentReady\Modules\Config as ModulesConfig;
use ContentReady\Util\Anchors;

final class HeadingAnchorGenerator
{
	public static function register(): void
	{
		add_action('save_post', [self::class, 'on_save_post'], 25, 3);
	}

	public static function on_save_post(int $post_id, \WP_Post $post, bool $update): void
	{
		if (wp_is_post_revision($post_id) || wp_is_post_autosave($post_id)) {
			return;
		}
		if (!in_array($post->post_status, ['publish', 'future'], true)) {
			return;
		}

		$options = Settings::get_options();
		$modules_cfg = ModulesConfig::normalize_modules_config($options['modules'] ?? null);
		$anchors_cfg = is_array($modules_cfg['anchors'] ?? null) ? $modules_cfg['anchors'] : [];
		if (empty($anchors_cfg['enabled'])) {
			return;
		}

		$html = (string)$post->post_content;
		if ($html === '') {
			return;
		}

		$meta = MetaStore::get($post_id);
		$existing = is_array($meta['anchors']['headings'] ?? null) ? $meta['anchors']['headings'] : [];
		$next = Anchors::build_heading_anchors($html, $existing);

		$prev_json = wp_json_encode(Anchors::normalize_heading_anchors($existing));
		$next_json = wp_json_encode($next);
		if (is_string($prev_json) && is_string($next_json) && $prev_json === $next_json) {
			return;
		}

		$meta['anchors']['headings'] = $next;
		MetaStore::update($post_id, $meta);
	}
}

