<?php

declare(strict_types=1);

namespace ContentReady\Admin\SettingsSections;

final class ImportExportSection
{
	public static function render(): void
	{
		echo '<hr />';
		echo '<h2>' . esc_html__('配置导入 / 导出（v1）', 'content-ready') . '</h2>';
		echo '<p>' . esc_html__('默认全量覆盖；失败不生效；支持仅导入/导出：网站基础配置、模块配置、页面类型配置。', 'content-ready') . '</p>';

		echo '<div style="display:flex;gap:24px;flex-wrap:wrap;">';
		echo '<div>';
		echo '<h3>导出</h3>';
		echo '<ul>';
		echo '<li><a class="button" href="' . esc_url(wp_nonce_url(admin_url('admin-post.php?action=cr_export_config&type=full'), 'cr_export_config')) . '">导出全部</a></li>';
		echo '<li><a class="button" href="' . esc_url(wp_nonce_url(admin_url('admin-post.php?action=cr_export_config&type=site'), 'cr_export_config')) . '">仅导出网站基础配置</a></li>';
		echo '<li><a class="button" href="' . esc_url(wp_nonce_url(admin_url('admin-post.php?action=cr_export_config&type=modules'), 'cr_export_config')) . '">仅导出模块配置</a></li>';
		echo '<li><a class="button" href="' . esc_url(wp_nonce_url(admin_url('admin-post.php?action=cr_export_config&type=page_types'), 'cr_export_config')) . '">仅导出页面类型配置</a></li>';
		echo '</ul>';
		echo '</div>';

		echo '<div>';
		echo '<h3>导入</h3>';
		echo '<form method="post" action="' . esc_url(admin_url('admin-post.php')) . '" enctype="multipart/form-data">';
		wp_nonce_field('cr_import_config');
		echo '<input type="hidden" name="action" value="cr_import_config" />';
		echo '<p><input type="file" name="config_file" accept="application/json" required /></p>';
		echo '<p><select name="type">';
		foreach (['full' => '导入全部（覆盖）', 'site' => '仅导入网站基础配置', 'modules' => '仅导入模块配置', 'page_types' => '仅导入页面类型配置'] as $k => $label) {
			echo '<option value="' . esc_attr($k) . '">' . esc_html($label) . '</option>';
		}
		echo '</select></p>';
		submit_button('开始导入', 'primary', 'submit', false);
		echo '</form>';
		echo '</div>';

		echo '</div>';
	}
}
