<?php

declare(strict_types=1);

namespace ContentReady\Admin;

/**
 * 后台提示（轻量）：用于把自动化“被门禁阻断”的原因展示给站长。
 *
 * 说明：
 * - 仅在后台展示（manage_options）。
 * - 同一条 notice 默认只展示一次（展示后写入 seen_at）。
 */
final class Notices
{
	private const OPTION_KEY = 'cr_automation_block_notice_v1';

	public static function register(): void
	{
		add_action('admin_notices', [self::class, 'render']);
	}

	public static function render(): void
	{
		if (!current_user_can('manage_options')) {
			return;
		}

		$row = get_option(self::OPTION_KEY, []);
		$row = is_array($row) ? $row : [];

		$at = (int)($row['at'] ?? 0);
		$seen_at = (int)($row['seen_at'] ?? 0);
		$message = sanitize_text_field((string)($row['message'] ?? ''));

		if ($at <= 0 || $message === '' || $at <= $seen_at) {
			return;
		}

		echo '<div class="notice notice-warning is-dismissible"><p>' . esc_html($message) . '</p></div>';

		$row['seen_at'] = $at;
		update_option(self::OPTION_KEY, $row, false);
	}
}

