<?php

declare(strict_types=1);

namespace ContentReady\Admin;

use ContentReady\Admin\SettingsSections\AutomationSection;
use ContentReady\Admin\Ui\Badges;
use ContentReady\Licensing\Capabilities;

final class AutomationPage
{
	public static function render_page(): void
	{
		if (!current_user_can('manage_options')) {
			wp_die(esc_html__('You do not have permission to access this page.', 'content-ready'));
		}

		$notice = isset($_GET['cr_notice']) ? sanitize_text_field((string)$_GET['cr_notice']) : '';
		$options = Settings::get_options();
		$is_pro = Capabilities::is_pro($options);

		echo '<div class="wrap">';
		echo '<h1>' . esc_html__('自动化', 'content-ready') . ' <span class="cr-badge-wrap">' . Badges::pro() . Badges::ai() . '</span></h1>';

		if ($notice === 'cr_saved') {
			echo '<div class="notice notice-info"><p>' . esc_html__('设置已保存。', 'content-ready') . '</p></div>';
		}

		if (!$is_pro) {
			echo '<div class="notice notice-info inline" style="margin-top:16px;"><p>' . esc_html__('当前为 Free：自动化功能需升级 Pro 解锁。', 'content-ready') . '</p></div>';
		}

		echo '<form method="post" action="' . esc_url(admin_url('admin-post.php')) . '">';
		wp_nonce_field('cr_save_settings');
		echo '<input type="hidden" name="action" value="cr_save_settings" />';
		echo '<input type="hidden" name="cr_settings_tab" value="automation" />';

		AutomationSection::render($options);

		submit_button('保存设置');
		echo '</form>';

		echo '</div>';
	}
}

