<?php

declare(strict_types=1);

namespace ContentReady\Admin;

final class AssessmentPage
{
	public static function render_page(): void
	{
		if (!current_user_can('manage_options')) {
			wp_die(esc_html__('You do not have permission to access this page.', 'content-ready'));
		}

		wp_enqueue_style(
			'content-ready-badges',
			CR_PLUGIN_URL . 'assets/badges.css',
			[],
			(string)(filemtime(CR_PLUGIN_DIR . 'assets/badges.css') ?: CR_VERSION)
		);

		wp_enqueue_script(
			'content-ready-admin-assessment',
			CR_PLUGIN_URL . 'assets/admin-assessment.js',
			['wp-api-fetch'],
			(string)(filemtime(CR_PLUGIN_DIR . 'assets/admin-assessment.js') ?: CR_VERSION),
			true
		);

		wp_localize_script('content-ready-admin-assessment', 'CR_ADMIN_ASSESSMENT', [
			'restNonce' => wp_create_nonce('wp_rest'),
			'settingsUrl' => admin_url('admin.php?page=content-ready-settings'),
		]);

		$items = get_posts([
			'post_type' => ['post', 'page'],
			'post_status' => 'publish',
			'numberposts' => 20,
		]);

		echo '<div class="wrap">';
		echo '<h1>' . esc_html__('Content Ready｜开始评估', 'content-ready') . '</h1>';
		echo '<p class="description">用于转化与结构性排查：当你更换主题或安装/更新 SEO 插件后，可在这里选择一篇已发布文章做“前端结构检查”。该检查不调用 AI，不消耗 Token。</p>';

		echo '<div style="margin-top:16px;padding:12px;border:1px solid #e5e7eb;background:#fff;">';
		echo '<p style="margin:0 0 8px;font-weight:600;">1) 选择一篇已发布文章</p>';
		echo '<select id="cr-assessment-post" style="min-width:420px;max-width:100%;">';
		echo '<option value="">请选择…</option>';
		foreach ($items as $p) {
			if (!$p instanceof \WP_Post) {
				continue;
			}
			$title = get_the_title($p);
			$label = ($title !== '' ? $title : ('#' . (string)$p->ID)) . '（' . $p->post_type . ' #' . (string)$p->ID . '）';
			echo '<option value="' . esc_attr((string)$p->ID) . '">' . esc_html($label) . '</option>';
		}
		echo '</select> ';
		echo '<button type="button" class="button button-primary" id="cr-assessment-run">开始检查（不消耗 Token）</button>';
		echo ' <a class="button" href="' . esc_url(admin_url('admin.php?page=content-ready')) . '">返回看板</a>';
		echo ' <a class="button" href="' . esc_url(admin_url('admin.php?page=content-ready-settings')) . '">打开设置</a>';
		echo '</div>';

		echo '<div id="cr-assessment-status" style="margin-top:12px;"></div>';
		echo '<div id="cr-assessment-results" style="margin-top:12px;"></div>';
		echo '</div>';
	}
}
