(function () {
	if (window.CR_PRO_UPSELL) return;

	var state = {
		open: false,
		overlay: null,
		backdrop: null,
		dialog: null,
		titleEl: null,
		descEl: null,
		primaryEl: null,
		secondaryEl: null,
		tertiaryEl: null,
	};

	function getSettings() {
		var s = {
			settingsUrl: '',
			licenseUrl: '',
			proBuyUrl: '',
		};

		try {
			if (window.CR_CLASSIC) {
				if (CR_CLASSIC.settingsUrl) s.settingsUrl = String(CR_CLASSIC.settingsUrl);
				if (CR_CLASSIC.licenseUrl) s.licenseUrl = String(CR_CLASSIC.licenseUrl);
				if (CR_CLASSIC.proBuyUrl) s.proBuyUrl = String(CR_CLASSIC.proBuyUrl);
			}
			if (window.CR_EDITOR) {
				if (!s.settingsUrl && CR_EDITOR.settingsUrl) s.settingsUrl = String(CR_EDITOR.settingsUrl);
				if (!s.licenseUrl && CR_EDITOR.licenseUrl) s.licenseUrl = String(CR_EDITOR.licenseUrl);
				if (!s.proBuyUrl && CR_EDITOR.proBuyUrl) s.proBuyUrl = String(CR_EDITOR.proBuyUrl);
			}
		} catch (e) {
			// ignore
		}

		return s;
	}

	function appendQuery(url, key, value) {
		try {
			if (!url) return '';
			if (url.indexOf(key + '=') !== -1) return url;
			return url + (url.indexOf('?') === -1 ? '?' : '&') + encodeURIComponent(key) + '=' + encodeURIComponent(value || '');
		} catch (e) {
			return url;
		}
	}

	function computeLicenseUrl(settingsUrl) {
		return appendQuery(settingsUrl || '', 'tab', 'license');
	}

	function ensureDom() {
		if (state.overlay) return;

		var overlay = document.createElement('div');
		overlay.className = 'cr-pro-upsell';
		overlay.setAttribute('aria-hidden', 'true');

		var backdrop = document.createElement('div');
		backdrop.className = 'cr-pro-upsell__backdrop';

		var dialog = document.createElement('div');
		dialog.className = 'cr-pro-upsell__dialog';
		dialog.setAttribute('role', 'dialog');
		dialog.setAttribute('aria-modal', 'true');

		var closeBtn = document.createElement('button');
		closeBtn.type = 'button';
		closeBtn.className = 'cr-pro-upsell__close';
		closeBtn.setAttribute('aria-label', '关闭');
		closeBtn.innerHTML = '&times;';

		var title = document.createElement('h3');
		title.className = 'cr-pro-upsell__title';
		title.textContent = '解锁 Pro 功能';

		var desc = document.createElement('p');
		desc.className = 'cr-pro-upsell__desc';
		desc.textContent = '当前功能为 Pro 专属。升级后可解锁更多能力：';

		var grid = document.createElement('div');
		grid.className = 'cr-pro-upsell__grid';
		var list = document.createElement('ul');
		list.className = 'cr-pro-upsell__list';

		var items = [
			'Pro 专属内容模块（更多模块可启用）',
			'单模块生成与一键应用（编辑器效率）',
			'发布后自动 GEO 与老文章批量回填（异步，不阻塞发布）',
			'每日配额更高（由授权端下发）',
			'在线授权校验（域名绑定，支持宽限期）',
		];
		items.forEach(function (t) {
			var li = document.createElement('li');
			li.textContent = t;
			list.appendChild(li);
		});
		grid.appendChild(list);

		var actions = document.createElement('div');
		actions.className = 'cr-pro-upsell__actions';

		var primary = document.createElement('a');
		primary.className = 'button button-primary cr-pro-upsell__primary';
		primary.href = '#';
		primary.target = '_blank';
		primary.rel = 'noopener noreferrer';
		primary.textContent = '升级到 Pro';

		var secondary = document.createElement('button');
		secondary.type = 'button';
		secondary.className = 'button cr-pro-upsell__secondary';
		secondary.textContent = '暂不升级';

		var tertiary = document.createElement('a');
		tertiary.className = 'cr-pro-upsell__tertiary';
		tertiary.href = '#';
		tertiary.target = '_blank';
		tertiary.rel = 'noopener noreferrer';
		tertiary.textContent = '我已购买，去填写 License Key';

		actions.appendChild(primary);
		actions.appendChild(secondary);
		actions.appendChild(tertiary);

		dialog.appendChild(closeBtn);
		dialog.appendChild(title);
		dialog.appendChild(desc);
		dialog.appendChild(grid);
		dialog.appendChild(actions);

		overlay.appendChild(backdrop);
		overlay.appendChild(dialog);
		document.body.appendChild(overlay);

		function close() {
			if (!state.open) return;
			state.open = false;
			overlay.classList.remove('is-open');
			overlay.setAttribute('aria-hidden', 'true');
		}

		backdrop.addEventListener('click', function () {
			close();
		});
		closeBtn.addEventListener('click', function () {
			close();
		});
		secondary.addEventListener('click', function () {
			close();
		});
		document.addEventListener('keydown', function (e) {
			if (!state.open) return;
			if (e && (e.key === 'Escape' || e.key === 'Esc')) close();
		});

		state.overlay = overlay;
		state.backdrop = backdrop;
		state.dialog = dialog;
		state.titleEl = title;
		state.descEl = desc;
		state.primaryEl = primary;
		state.secondaryEl = secondary;
		state.tertiaryEl = tertiary;
	}

	function open(opts) {
		opts = opts || {};
		ensureDom();

		var feature = String(opts.feature || '').trim();
		state.titleEl.textContent = String(opts.title || '解锁 Pro 功能');
		state.descEl.textContent = feature ? '当前功能为 Pro 专属：' + feature + '。升级后可解锁更多能力：' : '当前功能为 Pro 专属。升级后可解锁更多能力：';

		var settings = getSettings();
		var licenseUrl = String(opts.licenseUrl || settings.licenseUrl || computeLicenseUrl(settings.settingsUrl) || '').trim();
		var buyUrl = String(opts.proBuyUrl || settings.proBuyUrl || '').trim();

		var primaryUrl = String(opts.primaryUrl || buyUrl || licenseUrl || '#');
		state.primaryEl.href = primaryUrl;
		state.tertiaryEl.href = licenseUrl || primaryUrl;

		state.open = true;
		state.overlay.classList.add('is-open');
		state.overlay.setAttribute('aria-hidden', 'false');

		try {
			state.primaryEl.focus();
		} catch (e) {
			// ignore
		}
	}

	window.CR_PRO_UPSELL = {
		open: open,
	};
})();

