(function () {
	function getPageTypeModules(meta, options) {
		meta = meta || {};
		options = options || {};
		var ptId = meta.page_type || 'article';
		var pts = options.page_types || [];
		var ptModules = null;
		if (Array.isArray(pts)) {
			pts.some(function (pt) {
				if (pt && pt.id === ptId && Array.isArray(pt.modules)) {
					ptModules = pt.modules;
					return true;
				}
				return false;
			});
		}
		return ptModules;
	}

	function getVisibleModuleIds(meta, options) {
		meta = meta || {};
		options = options || {};
		var order = options.modules_order || [];
		var modulesCfg = options.modules || {};
		var ptModules = getPageTypeModules(meta, options);
		if (!Array.isArray(order)) return [];
		return order.filter(function (id) {
			var cfg = modulesCfg && modulesCfg[id];
			var inPageType = !ptModules || ptModules.indexOf(id) !== -1;
			var isContent = cfg && cfg.position !== 'code';
			return inPageType && isContent && cfg && cfg.enabled;
		});
	}

	function getGeneratableModuleIds(meta, options) {
		options = options || {};
		var modulesCfg = options.modules || {};
		return getVisibleModuleIds(meta, options).filter(function (id) {
			var cfg = modulesCfg && modulesCfg[id];
			return cfg && cfg.allow_ai;
		});
	}

	function getPageTypeOptions(options) {
		options = options || {};
		var pts = options.page_types || [];
		if (!Array.isArray(pts) || !pts.length) return [];
		return pts.map(function (pt) {
			return { label: pt.label, value: pt.id };
		});
	}

	function buildDrafts(modules, encodeDraft) {
		modules = modules || {};
		var out = {};
		Object.keys(modules).forEach(function (id) {
			out[id] = encodeDraft(id, modules[id] && modules[id].data);
		});
		return out;
	}

	function getAuthorDraft(meta) {
		meta = meta || {};
		var author = meta.author || {};
		return {
			mode: (author && author.mode) || 'inherit',
			name: (author && author.name) || '',
		};
	}

	window.CR_PAYLOAD_UTILS = {
		getPageTypeModules: getPageTypeModules,
		getVisibleModuleIds: getVisibleModuleIds,
		getGeneratableModuleIds: getGeneratableModuleIds,
		getPageTypeOptions: getPageTypeOptions,
		buildDrafts: buildDrafts,
		getAuthorDraft: getAuthorDraft,
	};
})();

