(function () {
  if (window.CR_EDITOR_SIDEBAR) return;

  function register(wp) {
    if (
      !wp ||
      !wp.plugins ||
      !wp.editPost ||
      !wp.element ||
      !wp.components ||
      !wp.apiFetch ||
      !wp.data
    )
      return;
    if (!window.CR_EDITOR_UTILS) return;
    if (!window.CR_PAYLOAD_UTILS) return;
    if (!window.CR_EDITOR_CHECKS) return;
    if (!window.CR_EDITOR_SIDEBAR_PANELS) return;

    var el = wp.element.createElement;
    var useEffect = wp.element.useEffect;
    var useMemo = wp.element.useMemo;
    var useState = wp.element.useState;

    var registerPlugin = wp.plugins.registerPlugin;
    var PluginSidebar = wp.editPost.PluginSidebar;

    var PanelBody = wp.components.PanelBody;
    var Button = wp.components.Button;
    var CheckboxControl = wp.components.CheckboxControl;
    var SelectControl = wp.components.SelectControl;
    var Spinner = wp.components.Spinner;
    var TextareaControl = wp.components.TextareaControl;
    var TextControl = wp.components.TextControl;

    var encodeDraft = window.CR_EDITOR_UTILS.encodeDraft;
    var decodeDraft = window.CR_EDITOR_UTILS.decodeDraft;
    var moduleStatus = window.CR_EDITOR_UTILS.moduleStatus;
    var notice = window.CR_EDITOR_UTILS.notice;
    var removeNotice = window.CR_EDITOR_UTILS.removeNotice;

    var buildDrafts = window.CR_PAYLOAD_UTILS.buildDrafts;
    var getAuthorDraft = window.CR_PAYLOAD_UTILS.getAuthorDraft;
    var getVisibleModuleIds = window.CR_PAYLOAD_UTILS.getVisibleModuleIds;
    var getGeneratableModuleIds = window.CR_PAYLOAD_UTILS.getGeneratableModuleIds;
    var getPageTypeOptions = window.CR_PAYLOAD_UTILS.getPageTypeOptions;

    function SidebarApp() {
      var postId = wp.data.select('core/editor').getCurrentPostId();

      var _a = useState(false),
        loading = _a[0],
        setLoading = _a[1];
      var _b = useState(null),
        payload = _b[0],
        setPayload = _b[1];
      var _c = useState(false),
        onlyMissing = _c[0],
        setOnlyMissing = _c[1];
      var _d = useState({}),
        drafts = _d[0],
        setDrafts = _d[1];
      var _e = useState(''),
        error = _e[0],
        setError = _e[1];
      var _f = useState(null),
        checkResult = _f[0],
        setCheckResult = _f[1];
      var _g = useState({ mode: 'inherit', name: '' }),
        authorDraft = _g[0],
        setAuthorDraft = _g[1];
      var _h = useState(false),
        previewLoading = _h[0],
        setPreviewLoading = _h[1];
      var _i = useState(''),
        previewError = _i[0],
        setPreviewError = _i[1];
      var _j = useState(null),
        previewData = _j[0],
        setPreviewData = _j[1];
      var _k = useState(''),
        slugInput = _k[0],
        setSlugInput = _k[1];
      var _l = useState(null),
        busy = _l[0],
        setBusy = _l[1];
      var _m = useState(null),
        feedback = _m[0],
        setFeedback = _m[1];

      function api(path, opts) {
        return wp.apiFetch(
          Object.assign(
            {
              path: '/cr/v1' + path,
            },
            opts || {}
          )
        );
      }

      function applyPayload(res) {
        setPayload(res);
        var meta = (res && res.meta) || {};
        setDrafts(buildDrafts(meta.modules, encodeDraft));
        setAuthorDraft(getAuthorDraft(meta));
        var last = meta && meta.checks && meta.checks.v1 && meta.checks.v1.result;
        if (last) setCheckResult(last);
      }

      function run(promiseFactory, fallbackMessage) {
        setError('');
        setFeedback(null);
        setLoading(true);
        return promiseFactory()
          .catch(function (e) {
            setError((e && e.message) || fallbackMessage || '操作失败');
          })
          .finally(function () {
            setLoading(false);
          });
      }

      function refreshSilently() {
        return api('/post/' + postId + '/meta').then(applyPayload);
      }

      function refresh() {
        return run(function () {
          return api('/post/' + postId + '/meta').then(applyPayload);
        }, '加载失败');
      }

      useEffect(
        function () {
          refresh();
          // eslint-disable-next-line react-hooks/exhaustive-deps
        },
        [postId]
      );

      useEffect(
        function () {
          if (!payload) return;
          if (slugInput) return;
          var post = payload.post || {};
          var sugs =
            (payload.meta &&
              payload.meta.modules &&
              payload.meta.modules.slug_suggestions &&
              payload.meta.modules.slug_suggestions.data &&
              payload.meta.modules.slug_suggestions.data.suggestions) ||
            [];
          if (Array.isArray(sugs) && sugs.length) {
            setSlugInput(String(sugs[0] || ''));
            return;
          }
          if (post && post.slug) setSlugInput(String(post.slug));
        },
        [payload, slugInput]
      );

      var moduleIds = useMemo(
        function () {
          if (!payload) return [];
          return getVisibleModuleIds(payload.meta, payload.options);
        },
        [payload]
      );

      var generatableIds = useMemo(
        function () {
          if (!payload) return [];
          return getGeneratableModuleIds(payload.meta, payload.options);
        },
        [payload]
      );

      var pageTypeOptions = useMemo(
        function () {
          if (!payload) return [];
          return getPageTypeOptions(payload.options);
        },
        [payload]
      );

      function setPageType(value) {
        return run(function () {
          return api('/post/' + postId + '/page-type', {
            method: 'POST',
            data: { page_type: value },
          }).then(refresh);
        }, '设置失败');
      }

      function saveAuthor(mode, name) {
        return run(function () {
          return api('/post/' + postId + '/author', {
            method: 'POST',
            data: { mode: mode, name: name },
          }).then(refresh);
        }, '保存失败');
      }

      function moduleLabel(moduleId) {
        var cfg =
          (payload &&
            payload.options &&
            payload.options.modules &&
            payload.options.modules[moduleId]) ||
          {};
        return (cfg && cfg.label) || moduleId;
      }

      function generateAll() {
        var modulesMeta = (payload && payload.meta && payload.meta.modules) || {};
        if (!onlyMissing) {
          var hasEdited = generatableIds.some(function (id) {
            var m = modulesMeta && modulesMeta[id];
            return m && (m.edited_at || 0) > (m.generated_at || 0);
          });
          if (
            hasEdited &&
            !window.confirm(
              '检测到你已手动编辑过部分模块内容，继续“一键生成”可能覆盖这些模块。是否继续？'
            )
          )
            return;
        }
        setError('');
        setFeedback({ type: 'info', text: '已开始生成 GEO…' });
        setBusy({ kind: 'generate_all', moduleId: null, startedAt: Date.now() });
        setLoading(true);
        if (removeNotice) removeNotice('cr-generate');
        if (notice) notice('info', 'Content Ready：已开始生成 GEO…', { id: 'cr-generate' });
        var doneMsg = '生成完成。';
        return api('/post/' + postId + '/generate', {
          method: 'POST',
          data: { only_missing: onlyMissing },
        })
          .then(function (res) {
            doneMsg = (res && res.generation_message) || doneMsg;
            return refreshSilently();
          })
          .then(function () {
            return api('/post/' + postId + '/check', { method: 'POST' })
              .then(function (r) {
                setCheckResult(r && r.result ? r.result : null);
              })
              .catch(function () {});
          })
          .then(function () {
            if (removeNotice) removeNotice('cr-generate');
            setFeedback({ type: 'success', text: doneMsg });
            if (notice)
              notice('success', 'Content Ready：' + doneMsg, {
                type: 'default',
                isDismissible: true,
              });
          })
          .catch(function (e) {
            if (removeNotice) removeNotice('cr-generate');
            if (notice) notice('error', 'Content Ready：生成失败。');
            var msg = (e && e.message) || '生成失败';
            setError(msg);
            setFeedback({ type: 'error', text: msg });
          })
          .finally(function () {
            setLoading(false);
            setBusy(null);
          });
      }

      function generateOne(moduleId) {
        var modulesMeta = (payload && payload.meta && payload.meta.modules) || {};
        var m = modulesMeta && modulesMeta[moduleId];
        var edited = m && (m.edited_at || 0) > (m.generated_at || 0);
        if (
          edited &&
          !window.confirm('检测到你已手动编辑过该模块内容，继续“重新生成”可能覆盖这些修改。是否继续？')
        ) {
          return null;
        }

        var label = moduleLabel(moduleId);
        setError('');
        setFeedback({ type: 'info', text: '已开始生成：' + label + '…' });
        setBusy({ kind: 'generate_one', moduleId: moduleId, startedAt: Date.now() });
        setLoading(true);
        return api('/post/' + postId + '/generate-module/' + moduleId, { method: 'POST' })
          .then(function () {
            setFeedback({ type: 'success', text: '生成完成：' + label + '。' });
            return refreshSilently();
          })
          .catch(function (e) {
            var msg = (e && e.message) || '生成失败';
            setError(msg);
            setFeedback({ type: 'error', text: msg });
          })
          .finally(function () {
            setLoading(false);
            setBusy(null);
          });
      }

      function saveModule(moduleId) {
        return run(function () {
          return api('/post/' + postId + '/update-module/' + moduleId, {
            method: 'POST',
            data: { data: decodeDraft(moduleId, drafts[moduleId] || '') },
          }).then(refresh);
        }, '保存失败');
      }

      function runCheck() {
        return window.CR_EDITOR_CHECKS.runCheck(api, postId, setError, setLoading, setCheckResult);
      }

      function runStructuredPreview() {
        setPreviewError('');
        setPreviewLoading(true);
        return api('/post/' + postId + '/structured-preview', { method: 'POST' })
          .then(function (res) {
            setPreviewData(res || null);
          })
          .catch(function (e) {
            setPreviewError((e && e.message) || '预览失败');
          })
          .finally(function () {
            setPreviewLoading(false);
          });
      }

      function applySlug(slug, ackPublished) {
        return run(function () {
          return api('/post/' + postId + '/apply-slug', {
            method: 'POST',
            data: { slug: slug || '', ack_published: !!ackPublished },
          })
            .then(function (res) {
              if (res && res.applied) setSlugInput(String(res.applied));
            })
            .then(refresh);
        }, '应用 slug 失败');
      }

      var meta = (payload && payload.meta) || null;
      var post = (payload && payload.post) || null;
      var so = (payload && payload.options && payload.options.structured_output) || {};
      var conflict = meta && meta.compat && meta.compat.jsonld_conflict;
      var checkedAt = (meta && meta.compat && meta.compat.checked_at) || 0;
      var modules = (meta && meta.modules) || {};
      var pageType = (meta && meta.page_type) || 'article';
      var site = (payload && payload.options && payload.options.site) || {};

      var statusCounts = useMemo(
        function () {
          var out = { gen: 0, edited: 0, missing: 0 };
          moduleIds.forEach(function (id) {
            var st = moduleStatus(modules[id]);
            if (st === '已生成') out.gen++;
            else if (st === '已修改') out.edited++;
            else out.missing++;
          });
          return out;
        },
        [moduleIds, modules]
      );

      var ctx = {
        el: el,
        PanelBody: PanelBody,
        Button: Button,
        CheckboxControl: CheckboxControl,
        SelectControl: SelectControl,
        Spinner: Spinner,
        TextareaControl: TextareaControl,
        TextControl: TextControl,

        postId: postId,
        loading: loading,
        error: error,
        payload: payload,
        meta: meta,
        post: post,

        onlyMissing: onlyMissing,
        setOnlyMissing: setOnlyMissing,
        drafts: drafts,
        setDrafts: setDrafts,

        authorDraft: authorDraft,
        setAuthorDraft: setAuthorDraft,

        modules: modules,
        moduleIds: moduleIds,
        moduleStatus: moduleStatus,

        statusCounts: statusCounts,
        pageType: pageType,
        pageTypeOptions: pageTypeOptions,

        so: so,
        checkedAt: checkedAt,
        conflict: conflict,

        site: site,

        refresh: refresh,
        setPageType: setPageType,
        saveAuthor: saveAuthor,
        generateAll: generateAll,
        generateOne: generateOne,
        saveModule: saveModule,

        busy: busy,
        feedback: feedback,

        previewLoading: previewLoading,
        previewError: previewError,
        previewData: previewData,
        runStructuredPreview: runStructuredPreview,

        slugInput: slugInput,
        setSlugInput: setSlugInput,
        applySlug: applySlug,
      };

      return el(
        PluginSidebar,
        {
          name: 'content-ready',
          title:
            (window.CR_EDITOR_SIDEBAR_CFG &&
              window.CR_EDITOR_SIDEBAR_CFG.uiLabel &&
              String(window.CR_EDITOR_SIDEBAR_CFG.uiLabel)) ||
            '内容就绪',
        },
        window.CR_EDITOR_SIDEBAR_PANELS.overview(ctx),
        window.CR_EDITOR_SIDEBAR_PANELS.advanced(ctx),
        window.CR_EDITOR_CHECKS.renderPanel(el, PanelBody, Button, checkResult, runCheck, loading),
        window.CR_EDITOR_SIDEBAR_PANELS.modules(ctx)
      );
    }

    registerPlugin('content-ready', {
      render: SidebarApp,
    });
  }

  window.CR_EDITOR_SIDEBAR = { register: register };
})();
