(function () {
	function renderAuthorHint(site) {
		var defMode = (site && site.author_mode) || 'wp';
		var brandName = (site && site.brand_author_name) || (site && site.display_name) || '';
		if (defMode === 'brand') return '站点默认：品牌/团队（' + (brandName || '未设置名称') + '）';
		return '站点默认：WordPress 作者';
	}

	function previewReasonText(preview) {
		if (!preview) return '';
		var reason = preview.blocked_reason || '';
		var compat = preview.compat || {};
		if (reason === 'structured_disabled') return '结构化输出未启用或已关闭。';
		if (reason === 'not_article_page_type') return '当前页面类型（' + (preview.page_type || 'unknown') + '）暂不输出结构化。';
		if (reason === 'auto_not_checked_yet') return '智能兼容：正在检查是否与其他结构化重复，完成前暂不输出。';
		if (reason === 'auto_check_failed')
			return '智能兼容：兼容性检查失败（' + ((compat && compat.last_error) || 'unknown') + '），前端已暂停结构化输出。';
		if (reason === 'auto_conflict_detected')
			return '智能兼容：检测到页面已有其他结构化输出，为避免重复已暂停输出（如 SEO 插件/主题的 Schema/JSON-LD）。';
		if (reason === 'post_not_found') return '文章不存在或已删除。';
		return reason ? '已阻止输出：' + reason : '';
	}

	function soModeLabel(mode) {
		mode = String(mode || 'auto');
		if (mode === 'force') return '强制输出';
		if (mode === 'off') return '关闭';
		return '智能兼容';
	}

	function previewObjectsText(preview) {
		if (!preview || !Array.isArray(preview.objects) || !preview.objects.length) return '';
		return preview.objects
			.map(function (obj) {
				try {
					return JSON.stringify(obj, null, 2);
				} catch (e) {
					return '';
				}
			})
			.filter(Boolean)
			.join('\n\n');
	}

	function badge(createEl, kind, title, text) {
		return createEl('span', { className: 'cr-badge cr-badge--' + kind, title: title || '' }, text || (kind === 'pro' ? 'PRO' : 'AI'));
	}

	function proBadge(createEl, title) {
		return badge(createEl, 'pro', title || 'Pro 功能', 'PRO');
	}

	function aiBadge(createEl, title) {
		return badge(createEl, 'ai', title || '将消耗 AI Token', 'AI');
	}

	function renderStructuredPreview(ctx) {
		var el = ctx.el;
		var Button = ctx.Button;
		var Spinner = ctx.Spinner;
		var TextareaControl = ctx.TextareaControl;

		var preview = ctx.previewData;
		var text = previewObjectsText(preview);
		var status = preview && preview.would_output ? '前端将输出' : '前端将不输出';
		var reason = previewReasonText(preview);

		return el(
			'div',
			{ style: { marginTop: '12px', paddingTop: '12px', borderTop: '1px solid #e5e7eb' } },
			el('div', { style: { display: 'flex', gap: '8px', alignItems: 'center' } }, [
				el(
					Button,
					{ isSecondary: true, onClick: ctx.runStructuredPreview, disabled: ctx.previewLoading },
					'结构化预览（排查）'
				),
				ctx.previewLoading ? el(Spinner, null) : null,
			]),
			ctx.previewError ? el('p', { style: { color: '#b91c1c' } }, ctx.previewError) : null,
			preview ? el('p', { style: { marginTop: '8px' } }, status + (reason ? '｜' + reason : '')) : null,
			preview && preview.compat && preview.compat.checked_at
				? el(
					'p',
					{ style: { color: '#6b7280', marginTop: '6px' } },
					'兼容性检查时间：' + new Date(preview.compat.checked_at * 1000).toLocaleString()
				)
				: null,
			preview
				? el(
					'p',
					{ style: { color: '#6b7280', marginTop: '6px' } },
					'如果想由本插件负责结构化输出：请在对应 SEO 插件中关闭结构化输出（Schema/JSON-LD）（全局/该文章类型/单篇文章），或将本插件切到“强制输出”（Pro）。'
				)
				: null,
			text
				? el(TextareaControl, {
					label: '结构化代码（预览）',
					value: text,
					disabled: true,
					help: '仅用于排查；前端是否输出请以上方“状态/原因”为准。',
				})
				: preview
					? el('p', { style: { color: '#6b7280' } }, '暂无可预览对象（可能未配置 Article/FAQ，或页面类型不输出）。')
					: null
		);
	}

	function overview(ctx) {
		var el = ctx.el;
		var PanelBody = ctx.PanelBody;
		var Button = ctx.Button;
		var CheckboxControl = ctx.CheckboxControl;
		var SelectControl = ctx.SelectControl;
		var Spinner = ctx.Spinner;
		var TextControl = ctx.TextControl;

		var busy = ctx.busy || null;
		var isGeneratingAll = !!(busy && busy.kind === 'generate_all');
		var feedback = ctx.feedback || null;
		var caps =
			(ctx.payload && ctx.payload.options && ctx.payload.options.capabilities) || {};
		var features = (caps && caps.features) || {};
		var canAuthor = !!features.author_strategy;

		var aiPossible = false;
		var optModules = (ctx.payload && ctx.payload.options && ctx.payload.options.modules) || {};
		(ctx.moduleIds || []).forEach(function (id) {
			var cfg0 = (optModules && optModules[id]) || {};
			if (cfg0 && cfg0.allow_ai && id !== 'last_updated') aiPossible = true;
		});

		return el(
			PanelBody,
			{ title: '概览', initialOpen: true },
			el(
				'div',
				null,
				el(Button, { isSecondary: true, onClick: ctx.refresh, disabled: ctx.loading }, '刷新状态'),
				window.CR_EDITOR && window.CR_EDITOR.settingsUrl
					? el(
						Button,
						{
							isSecondary: true,
							onClick: function () {
								window.open(window.CR_EDITOR.settingsUrl, '_blank');
							},
							disabled: ctx.loading,
							style: { marginLeft: '8px' },
						},
						'打开设置页'
					)
					: null,
				ctx.loading ? el(Spinner, null) : null,
				feedback && feedback.text
					? el(
						'p',
						{
							style: {
								color:
									feedback.type === 'success'
										? '#15803d'
										: feedback.type === 'error'
											? '#b91c1c'
											: '#6b7280',
								marginTop: '8px',
							},
						},
						feedback.text
					)
					: null,
				ctx.error ? el('p', { style: { color: '#b91c1c' } }, ctx.error) : null,
				el(
					'p',
					{ style: { color: '#111827', marginTop: '8px' } },
					'模块状态：已生成 ' + ctx.statusCounts.gen + ' / 已修改 ' + ctx.statusCounts.edited + ' / 缺失 ' + ctx.statusCounts.missing
				),
				ctx.conflict && ctx.so && ctx.so.enabled && ctx.so.mode === 'auto'
					? el(
						'p',
						{ style: { color: '#b45309' } },
						'检测到站点已有其他结构化输出（可能来自 SEO 插件/主题）：为避免重复，当前“智能兼容”已暂停本插件结构化输出（前端模块不受影响）。如需由本插件输出：请关闭其它来源的结构化输出（Schema/JSON-LD），或切到“强制输出”（Pro）。'
					)
					: null
			),
			el(SelectControl, {
				label: '页面类型',
				value: ctx.pageType,
				options: ctx.pageTypeOptions.length ? ctx.pageTypeOptions : [{ label: '通用文章', value: 'article' }],
				onChange: ctx.setPageType,
			}),
			canAuthor
				? el(
					'div',
					null,
					el('div', { className: 'cr-badge-wrap', style: { margin: '6px 0' } }, proBadge(el, '作者策略为 Pro 功能')),
					el(SelectControl, {
						label: '作者策略（结构化输出）',
						value: ctx.authorDraft.mode || 'inherit',
						help: renderAuthorHint(ctx.site),
						options: [
							{ label: '跟随站点默认', value: 'inherit' },
							{ label: 'WordPress 作者', value: 'wp' },
							{ label: '站点品牌 / 团队', value: 'brand' },
						],
						onChange: function (v) {
							var next = Object.assign({}, ctx.authorDraft, { mode: v });
							ctx.setAuthorDraft(next);
							ctx.saveAuthor(next.mode, next.name || '');
						},
					})
				)
				: el('p', { style: { color: '#6b7280' } }, '作者策略：', proBadge(el, '作者策略为 Pro 功能'), ' Free 固定使用 WordPress 作者。'),
			canAuthor && ctx.authorDraft.mode === 'brand'
				? el(TextControl, {
					label: '品牌/团队名称（可选）',
					value: ctx.authorDraft.name || '',
					help: '留空则使用站点默认品牌作者名称。',
					onChange: function (v) {
						ctx.setAuthorDraft(Object.assign({}, ctx.authorDraft, { name: v }));
					},
				})
				: null,
			canAuthor && ctx.authorDraft.mode === 'brand'
				? el(
					'span',
					{ className: 'cr-badge-wrap' },
					el(
						Button,
						{
							isSecondary: true,
							onClick: function () {
								ctx.saveAuthor(ctx.authorDraft.mode, ctx.authorDraft.name || '');
							},
							disabled: ctx.loading,
						},
						'保存作者策略'
					),
					proBadge(el, '作者策略为 Pro 功能')
				)
				: null,
			el(CheckboxControl, {
				label: '仅补全缺失（默认关闭）',
				checked: ctx.onlyMissing,
				onChange: ctx.setOnlyMissing,
			}),
			el(
				'div',
				{ style: { display: 'flex', gap: '8px', alignItems: 'center' } },
				el(
					'span',
					{ className: 'cr-badge-wrap' },
					el(
						Button,
						{ isPrimary: true, onClick: ctx.generateAll, disabled: ctx.loading },
						isGeneratingAll ? '正在生成…' : '生成 GEO'
					),
					aiPossible ? aiBadge(el, '生成将消耗 AI Token') : null
				),
				ctx.loading ? el(Spinner, null) : null
			),
			el('p', { style: { color: '#6b7280', marginTop: '6px' } }, '提示：生成完成后可点“发布前检查”确认是否还有缺失/警告。')
		);
	}

	function advanced(ctx) {
		var el = ctx.el;
		var PanelBody = ctx.PanelBody;
		var Button = ctx.Button;
		var Spinner = ctx.Spinner;
		var TextareaControl = ctx.TextareaControl;
		return el(
			PanelBody,
			{ title: '结构化输出（排查）', initialOpen: false },
			el(
				'p',
				null,
				'状态：' +
					(ctx.so && ctx.so.enabled ? '启用' : '关闭') +
					' / 模式：' +
					soModeLabel(ctx.so && ctx.so.mode ? ctx.so.mode : 'auto')
			),
			el('p', null, '兼容性检查：' + (ctx.checkedAt ? new Date(ctx.checkedAt * 1000).toLocaleString() : '未完成')),
			el('p', null, '重复检测：' + (ctx.conflict ? '是（已暂停输出）' : '否')),
			ctx.meta && ctx.meta.compat && ctx.meta.compat.last_error
				? el('p', { style: { color: '#b91c1c' } }, '检查错误：' + ctx.meta.compat.last_error)
				: null,
			el(
				'p',
				{ style: { color: '#6b7280' } },
				'如果想由本插件负责结构化输出：请关闭其它来源的结构化输出（Schema/JSON-LD），或切换为“强制输出”（Pro）。'
			),
			renderStructuredPreview({
				el: el,
				Button: Button,
				Spinner: Spinner,
				TextareaControl: TextareaControl,
				previewLoading: ctx.previewLoading,
				previewError: ctx.previewError,
				previewData: ctx.previewData,
				runStructuredPreview: ctx.runStructuredPreview,
			})
		);
	}

	function modules(ctx) {
		if (window.CR_EDITOR_SIDEBAR_MODULES_PANEL) {
			return window.CR_EDITOR_SIDEBAR_MODULES_PANEL(ctx);
		}
		var el = ctx.el;
		var PanelBody = ctx.PanelBody;
		return el(PanelBody, { title: '模块', initialOpen: true }, el('p', { style: { color: '#6b7280' } }, '模块面板加载失败：缺少依赖脚本。'));
	}

	window.CR_EDITOR_SIDEBAR_PANELS = {
		overview: overview,
		advanced: advanced,
		modules: modules,
	};
})();
