(function () {
	function safeItems(result) {
		return result && Array.isArray(result.items) ? result.items : [];
	}

	function normalizeSummary(result) {
		var s = (result && result.summary) || null;
		var fail = s && typeof s.fail === 'number' ? s.fail : null;
		var warn = s && typeof s.warn === 'number' ? s.warn : null;
		var pass = s && typeof s.pass === 'number' ? s.pass : null;

		if (fail === null || warn === null || pass === null) {
			fail = 0;
			warn = 0;
			pass = 0;
			safeItems(result).forEach(function (it) {
				var level = (it && it.level) || '';
				if (level === 'fail') fail++;
				else if (level === 'warn') warn++;
				else if (level === 'pass') pass++;
			});
		}

		return { fail: fail || 0, warn: warn || 0, pass: pass || 0 };
	}

	function groupItems(result) {
		var out = { fail: [], warn: [], pass: [] };
		safeItems(result).forEach(function (it) {
			var level = (it && it.level) || 'warn';
			if (!out[level]) level = 'warn';
			out[level].push(it);
		});
		return out;
	}

	window.CR_CLASSIC_CHECKS = {
		runCheck: function (api, postId, root) {
			return api('/post/' + postId + '/check', { method: 'POST' }).then(function (res) {
				var box = root ? root.querySelector('#cr-classic-check-result') : null;
				if (!box) return;
				box.innerHTML = '';
				var r = res && res.result ? res.result : null;
				if (!r) return;

				function p(text) {
					var el = document.createElement('p');
					el.textContent = text;
					return el;
				}
				function strongP(text) {
					var el = document.createElement('p');
					var s = document.createElement('strong');
					s.textContent = text;
					el.appendChild(s);
					el.style.margin = '8px 0 4px';
					return el;
				}
				function li(text, color, moduleId) {
					var el = document.createElement('li');
					el.style.display = 'flex';
					el.style.gap = '8px';
					el.style.alignItems = 'center';
					el.style.color = color;
					var span = document.createElement('span');
					span.textContent = text;
					el.appendChild(span);
					if (moduleId && window.CR_CLASSIC_UTILS && window.CR_CLASSIC_UTILS.scrollToModule) {
						var btn = document.createElement('button');
						btn.type = 'button';
						btn.className = 'button';
						btn.textContent = '跳转';
						btn.addEventListener('click', function (e) {
							e.preventDefault();
							window.CR_CLASSIC_UTILS.scrollToModule(moduleId);
						});
						el.appendChild(btn);
					}
					return el;
				}

				var s0 = normalizeSummary(r);
				box.appendChild(p('未达标：' + s0.fail + ' / 警告：' + s0.warn + ' / 通过：' + s0.pass));

				var groups = groupItems(r);
				[
					{ key: 'fail', title: '未达标', color: '#b91c1c' },
					{ key: 'warn', title: '警告', color: '#b45309' },
					{ key: 'pass', title: '通过', color: '#065f46' },
				].forEach(function (g) {
					var list = groups[g.key] || [];
					if (!list.length) return;

					box.appendChild(strongP(g.title + '（' + list.length + '）'));

					var ul = document.createElement('ul');
					ul.style.paddingLeft = '18px';
					ul.style.margin = '0';
					list.forEach(function (it) {
						var level = (it && it.level) || '';
						var color = level === 'fail' ? '#b91c1c' : level === 'warn' ? '#b45309' : '#065f46';
						ul.appendChild(li((it && (it.message || it.code)) || 'unknown', color, it && it.module_id));
					});
					box.appendChild(ul);
				});
			});
		},
	};
})();

