(function () {
  function byId(id) {
    return document.getElementById(id);
  }

  function initSiteLogoPicker() {
    var input = byId('cr_site_logo_url');
    var pickBtn = byId('cr_site_logo_pick');
    var clearBtn = byId('cr_site_logo_clear');
    var preview = byId('cr_site_logo_preview');

    if (!input || !pickBtn || !preview) return;

    function renderPreview(url) {
      preview.innerHTML = '';
      if (!url) return;

      var img = document.createElement('img');
      img.src = url;
      img.alt = '';
      img.style.maxWidth = '120px';
      img.style.height = 'auto';
      img.style.border = '1px solid #e5e7eb';
      img.style.borderRadius = '8px';
      img.style.padding = '6px';
      img.style.background = '#fff';
      preview.appendChild(img);
    }

    renderPreview(input.value);

    pickBtn.addEventListener('click', function (e) {
      e.preventDefault();

      if (!window.wp || !window.wp.media) {
        // wp.media 未加载时不阻塞页面使用
        return;
      }

      var frame = window.wp.media({
        title: '选择网站 Logo',
        button: { text: '使用该图片' },
        library: { type: 'image' },
        multiple: false,
      });

      frame.on('select', function () {
        var selection = frame.state().get('selection');
        if (!selection) return;

        var attachment = selection.first();
        if (!attachment) return;

        var data = attachment.toJSON();
        if (!data || !data.url) return;

        input.value = data.url;
        renderPreview(data.url);
      });

      frame.open();
    });

    if (clearBtn) {
      clearBtn.addEventListener('click', function (e) {
        e.preventDefault();
        input.value = '';
        renderPreview('');
      });
    }
  }

  function initModulesSearch() {
    var input = byId('cr-modules-search');
    var wrap = byId('cr-modules-cards');
    if (!input || !wrap) return;

    var empty = byId('cr-modules-search-empty');
    var count = byId('cr-modules-search-count');
    var cards = Array.prototype.slice.call(wrap.querySelectorAll('.cr-module-card'));
    var groups = Array.prototype.slice.call(wrap.querySelectorAll('.cr-modules-group'));

    function norm(s) {
      return String(s || '').toLowerCase();
    }

    function cardHaystack(card) {
      return (
        norm(card.getAttribute('data-module-id')) +
        ' ' +
        norm(card.getAttribute('data-module-label')) +
        ' ' +
        norm(card.getAttribute('data-module-intro'))
      );
    }

    function update() {
      var q = norm(input.value).trim();
      var visible = 0;

      cards.forEach(function (card) {
        var show = !q || cardHaystack(card).indexOf(q) >= 0;
        card.style.display = show ? '' : 'none';
        if (show) visible++;
      });

      groups.forEach(function (group) {
        var groupCards = group.querySelectorAll('.cr-module-card');
        var any = false;
        for (var i = 0; i < groupCards.length; i++) {
          if (groupCards[i].style.display !== 'none') {
            any = true;
            break;
          }
        }
        group.style.display = any ? '' : 'none';
      });

      if (count) {
        count.textContent = q ? '匹配：' + visible + ' / ' + cards.length : '共 ' + cards.length + ' 个模块';
      }
      if (empty) {
        empty.style.display = visible ? 'none' : 'block';
      }
    }

    input.addEventListener('input', update);
    update();
  }

  initSiteLogoPicker();
  initModulesSearch();
})();

