(function () {
	if (!window.ContentReadyDeactivationFeedback) {
		return;
	}

	var cfg = window.ContentReadyDeactivationFeedback;
	var pluginBasename = String(cfg.pluginBasename || '');
	if (!pluginBasename) {
		return;
	}

	function $(sel, root) {
		return (root || document).querySelector(sel);
	}

	function createEl(html) {
		var t = document.createElement('template');
		t.innerHTML = String(html).trim();
		return t.content.firstElementChild;
	}

	function escapeText(text) {
		var span = document.createElement('span');
		span.textContent = String(text);
		return span.innerHTML;
	}

	function getPluginActionFromHref(href) {
		try {
			var url = new URL(href, window.location.href);
			var action = url.searchParams.get('action') || '';
			var plugin = url.searchParams.get('plugin') || '';
			var checked = url.searchParams.getAll('checked[]') || [];

			if (action === 'deactivate' && decodeURIComponent(plugin) === pluginBasename) {
				return { type: 'deactivate' };
			}
			if ((action === 'delete-selected' || action === 'delete-plugin') && checked.map(decodeURIComponent).indexOf(pluginBasename) !== -1) {
				return { type: 'delete' };
			}
			if ((action === 'delete-selected' || action === 'delete-plugin') && decodeURIComponent(plugin) === pluginBasename) {
				return { type: 'delete' };
			}
		} catch (e) {
			// ignore
		}
		return null;
	}

	function buildModal(actionType) {
		var installedDays = typeof cfg.installedDays === 'number' ? cfg.installedDays : -1;
		var usedPostsCount = typeof cfg.usedPostsCount === 'number' ? cfg.usedPostsCount : 0;

		var daysText = installedDays >= 0 ? installedDays + ' 天' : '（未知）';
		var usedText = usedPostsCount + ' 篇';
		var title = actionType === 'delete' ? '在你卸载 Content Ready 前，想请你确认两件事' : '在你停用 Content Ready 前，想请你确认两件事';

		var diag = [
			'Content Ready 版本：' + String(cfg.pluginVersion || ''),
			'WordPress：' + String(cfg.wpVersion || ''),
			'已安装天数：' + String(installedDays),
			'已使用文章数：' + String(usedPostsCount),
			'动作：' + actionType,
		].join('\n');

		var el = createEl(
			'<div class="cr-deact-overlay" role="dialog" aria-modal="true" aria-labelledby="cr-deact-title">' +
				'<div class="cr-deact-modal">' +
					'<h2 id="cr-deact-title">' + escapeText(title) + '</h2>' +
					'<p>你已安装 <strong>' + escapeText(daysText) + '</strong>，已有 <strong>' + escapeText(usedText) + '</strong> 的文章使用了本插件的内容模块。</p>' +
					'<ul>' +
						'<li>停用后：前端将不再渲染内容模块与结构化输出（JSON-LD）。</li>' +
						'<li>已生成的数据不会立刻丢失：仍保存在文章的 <code>post_meta</code> 里，可再次启用恢复展示。</li>' +
					'</ul>' +
					'<div class="cr-deact-field">' +
						'<label for="cr-deact-reason">主要原因（可选）</label>' +
						'<select id="cr-deact-reason">' +
							'<option value="">— 不选择 —</option>' +
							'<option value="not_working">不好用/没生效</option>' +
							'<option value="hard_to_use">操作成本太高</option>' +
							'<option value="missing_features">缺少我需要的功能</option>' +
							'<option value="conflict">与主题/插件冲突</option>' +
							'<option value="temporary">临时停用</option>' +
							'<option value="other">其他</option>' +
						'</select>' +
					'</div>' +
					'<div class="cr-deact-field">' +
						'<label for="cr-deact-details">补充说明（可选）</label>' +
						'<textarea id="cr-deact-details" rows="3" placeholder="例如：哪里卡住了/希望怎么改"></textarea>' +
					'</div>' +
					'<div class="cr-deact-actions">' +
						'<button type="button" class="button button-primary" id="cr-deact-submit">提交并继续</button>' +
						'<button type="button" class="button" id="cr-deact-skip">跳过并继续</button>' +
						'<span class="cr-deact-spacer"></span>' +
						'<button type="button" class="button-link" id="cr-deact-copy">复制诊断信息</button>' +
						'<button type="button" class="button-link" id="cr-deact-cancel">取消</button>' +
					'</div>' +
					'<div class="cr-deact-note">提示：反馈会仅保存在本地站点（不自动上传）。你也可以把“诊断信息”粘贴到你的沟通渠道用于排查。</div>' +
					'<textarea style="position:absolute;left:-9999px;top:-9999px;" aria-hidden="true" tabindex="-1" readonly>' + escapeText(diag) + '</textarea>' +
				'</div>' +
			'</div>'
		);

		return el;
	}

	function submitFeedback(actionType, reason, details) {
		var params = new URLSearchParams();
		params.set('action', 'cr_submit_deactivation_feedback');
		params.set('nonce', String(cfg.nonce || ''));
		params.set('action_type', String(actionType || ''));
		params.set('reason', String(reason || ''));
		params.set('details', String(details || ''));

		return fetch(String(cfg.ajaxUrl || ''), {
			method: 'POST',
			credentials: 'same-origin',
			headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
			body: params.toString(),
		}).catch(function () {});
	}

	function openModal(actionType, continueHref) {
		var overlay = buildModal(actionType);
		document.body.appendChild(overlay);

		var reasonEl = $('#cr-deact-reason', overlay);
		var detailsEl = $('#cr-deact-details', overlay);
		var hiddenTextarea = overlay.querySelector('textarea[readonly]');

		function close() {
			overlay.remove();
		}

		function proceed() {
			window.location.href = continueHref;
		}

		$('#cr-deact-cancel', overlay).addEventListener('click', function () {
			close();
		});
		overlay.addEventListener('click', function (e) {
			if (e.target === overlay) {
				close();
			}
		});
		document.addEventListener(
			'keydown',
			function onKey(e) {
				if (!document.body.contains(overlay)) {
					document.removeEventListener('keydown', onKey);
					return;
				}
				if (e.key === 'Escape') {
					e.preventDefault();
					close();
				}
			},
			true
		);

		$('#cr-deact-copy', overlay).addEventListener('click', function () {
			try {
				hiddenTextarea.focus();
				hiddenTextarea.select();
				document.execCommand('copy');
			} catch (e) {
				// ignore
			}
		});

		$('#cr-deact-skip', overlay).addEventListener('click', function () {
			close();
			proceed();
		});

		$('#cr-deact-submit', overlay).addEventListener('click', function () {
			var reason = reasonEl ? reasonEl.value : '';
			var details = detailsEl ? detailsEl.value : '';
			submitFeedback(actionType, reason, details).finally(function () {
				close();
				proceed();
			});
		});

		if (reasonEl) {
			reasonEl.focus();
		}
	}

	function onPluginRowClick(e) {
		var a = e.target && e.target.closest ? e.target.closest('a') : null;
		if (!a || !a.href) {
			return;
		}

		var actionInfo = getPluginActionFromHref(a.href);
		if (!actionInfo) {
			return;
		}

		e.preventDefault();
		openModal(actionInfo.type, a.href);
	}

	// WordPress 插件列表的每行都有 data-plugin="<basename>"。
	var row = document.querySelector('tr[data-plugin="' + pluginBasename.replace(/"/g, '\\"') + '"]');
	if (row) {
		row.addEventListener('click', onPluginRowClick, true);
	}
})();
